/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.transaction;

import com.codingapi.txlcn.commons.exception.TxManagerException;
import com.codingapi.txlcn.manager.config.TxManagerConfig;
import com.codingapi.txlcn.manager.core.message.RpcExecuteService;
import com.codingapi.txlcn.manager.core.message.TransactionCmd;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.params.InitClientParams;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rpc_init-client")
public class InitClientService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(InitClientService.class);
    @Autowired
    private RpcClient rpcClient;
    @Autowired
    private TxManagerConfig txManagerConfig;

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        log.info("init client - >{}", (Object)transactionCmd);
        InitClientParams initClientParams = (InitClientParams)transactionCmd.getMsg().loadBean(InitClientParams.class);
        this.rpcClient.bindAppName(transactionCmd.getRemoteKey(), initClientParams.getAppName());
        initClientParams.setDtxTime(this.txManagerConfig.getDtxTime());
        return initClientParams;
    }
}

