/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.transaction;

import com.codingapi.txlcn.commons.exception.TransactionException;
import com.codingapi.txlcn.commons.exception.TxManagerException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.manager.core.context.DTXTransaction;
import com.codingapi.txlcn.manager.core.context.DTXTransactionContext;
import com.codingapi.txlcn.manager.core.context.TransactionManager;
import com.codingapi.txlcn.manager.core.group.TransactionUnit;
import com.codingapi.txlcn.manager.core.message.RpcExecuteService;
import com.codingapi.txlcn.manager.core.message.TransactionCmd;
import com.codingapi.txlcn.spi.message.params.JoinGroupParams;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rpc_join-group")
public class JoinGroupExecuteService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(JoinGroupExecuteService.class);
    private final TransactionManager transactionManager;
    private final DTXTransactionContext transactionContext;
    private final TxLogger txLogger;

    @Autowired
    public JoinGroupExecuteService(TxLogger txLogger, TransactionManager transactionManager, DTXTransactionContext transactionContext) {
        this.txLogger = txLogger;
        this.transactionManager = transactionManager;
        this.transactionContext = transactionContext;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        DTXTransaction dtxTransaction = this.transactionContext.getTransaction(transactionCmd.getGroupId());
        try {
            JoinGroupParams joinGroupParams = (JoinGroupParams)transactionCmd.getMsg().loadBean(JoinGroupParams.class);
            this.txLogger.trace(transactionCmd.getGroupId(), joinGroupParams.getUnitId(), "transaction", "start join group");
            TransactionUnit transactionUnit = new TransactionUnit(joinGroupParams.getUnitId(), joinGroupParams.getUnitType(), joinGroupParams.getTransactionState(), transactionCmd.getRemoteKey());
            this.transactionManager.join(dtxTransaction, transactionUnit);
            this.txLogger.trace(transactionCmd.getGroupId(), joinGroupParams.getUnitId(), "transaction", "over join group");
        }
        catch (TransactionException e) {
            throw new TxManagerException(e.getLocalizedMessage());
        }
        return null;
    }
}

