/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.transaction;

import com.alibaba.fastjson.JSON;
import com.codingapi.txlcn.commons.exception.TxManagerException;
import com.codingapi.txlcn.commons.exception.UserRollbackException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.manager.core.context.DTXTransaction;
import com.codingapi.txlcn.manager.core.context.DTXTransactionContext;
import com.codingapi.txlcn.manager.core.context.TransactionManager;
import com.codingapi.txlcn.manager.core.message.RpcExecuteService;
import com.codingapi.txlcn.manager.core.message.TransactionCmd;
import com.codingapi.txlcn.spi.message.params.NotifyGroupParams;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rpc_notify-group")
public class NotifyGroupExecuteService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(NotifyGroupExecuteService.class);
    private final TxLogger txLogger;
    private final TransactionManager transactionManager;
    private final DTXTransactionContext transactionContext;

    @Autowired
    public NotifyGroupExecuteService(TxLogger txLogger, TransactionManager transactionManager, DTXTransactionContext transactionContext) {
        this.txLogger = txLogger;
        this.transactionManager = transactionManager;
        this.transactionContext = transactionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        DTXTransaction dtxTransaction = this.transactionContext.getTransaction(transactionCmd.getGroupId());
        try {
            NotifyGroupParams notifyGroupParams = (NotifyGroupParams)transactionCmd.getMsg().loadBean(NotifyGroupParams.class);
            log.debug("notify group params: {}", (Object)JSON.toJSONString((Object)notifyGroupParams));
            int commitState = notifyGroupParams.getState();
            int transactionState = this.transactionManager.transactionState(dtxTransaction);
            boolean hasThrow = false;
            if (transactionState == 0) {
                commitState = 0;
                hasThrow = true;
            }
            this.txLogger.trace(transactionCmd.getGroupId(), "", "transaction", "notify group " + notifyGroupParams.getState());
            if (commitState == 1) {
                this.transactionManager.commit(dtxTransaction);
            } else if (commitState == 0) {
                this.transactionManager.rollback(dtxTransaction);
            }
            if (hasThrow) {
                throw new UserRollbackException("user mandatory rollback");
            }
        }
        finally {
            this.transactionManager.close(dtxTransaction);
            this.txLogger.trace(transactionCmd.getGroupId(), "", "transaction", "notify group over");
        }
        return null;
    }
}

