/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.transaction;

import com.codingapi.txlcn.commons.exception.TxManagerException;
import com.codingapi.txlcn.manager.core.context.DTXTransactionContext;
import com.codingapi.txlcn.manager.core.context.TransactionManager;
import com.codingapi.txlcn.manager.core.message.RpcExecuteService;
import com.codingapi.txlcn.manager.core.message.TransactionCmd;
import com.codingapi.txlcn.manager.support.service.TxExceptionService;
import com.codingapi.txlcn.manager.support.service.WriteTxExceptionDTO;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.params.TxExceptionParams;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpc_write-compensation")
public class WriteTxExceptionExecuteService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(WriteTxExceptionExecuteService.class);
    private final TxExceptionService compensationService;
    private final RpcClient rpcClient;
    private final TransactionManager transactionManager;
    private final DTXTransactionContext transactionContext;

    @Autowired
    public WriteTxExceptionExecuteService(TxExceptionService compensationService, RpcClient rpcClient, TransactionManager transactionManager, DTXTransactionContext transactionContext) {
        this.compensationService = compensationService;
        this.rpcClient = rpcClient;
        this.transactionManager = transactionManager;
        this.transactionContext = transactionContext;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        try {
            TxExceptionParams txExceptionParams = (TxExceptionParams)transactionCmd.getMsg().loadBean(TxExceptionParams.class);
            WriteTxExceptionDTO writeTxExceptionReq = new WriteTxExceptionDTO();
            writeTxExceptionReq.setModId(this.rpcClient.getAppName(transactionCmd.getRemoteKey()));
            int transactionState = this.transactionManager.transactionState(this.transactionContext.getTransaction(txExceptionParams.getGroupId()));
            writeTxExceptionReq.setTransactionState(transactionState == -1 ? txExceptionParams.getTransactionState() : transactionState);
            writeTxExceptionReq.setGroupId(txExceptionParams.getGroupId());
            writeTxExceptionReq.setUnitId(txExceptionParams.getUnitId());
            writeTxExceptionReq.setRegistrar(Objects.isNull(txExceptionParams.getRegistrar()) ? (short)-1 : txExceptionParams.getRegistrar());
            this.compensationService.writeTxException(writeTxExceptionReq);
        }
        catch (Exception e) {
            throw new TxManagerException((Throwable)e);
        }
        return null;
    }
}

