/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.db.redis;

import com.alibaba.fastjson.JSON;
import com.codingapi.txlcn.commons.exception.JoinGroupException;
import com.codingapi.txlcn.manager.config.TxManagerConfig;
import com.codingapi.txlcn.manager.core.group.GroupRelationship;
import com.codingapi.txlcn.manager.core.group.TransUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisGroupRelationship
implements GroupRelationship {
    private static final Logger log = LoggerFactory.getLogger(RedisGroupRelationship.class);
    private static final String REDIS_PREFIX = "tx.manager:group:";
    private static final String REDIS_GROUP_STATE = "tx.manager:group::transactionState";
    private final RedisTemplate<String, String> redisTemplate;
    private final TxManagerConfig managerConfig;

    @Autowired
    public RedisGroupRelationship(RedisTemplate<String, String> redisTemplate, TxManagerConfig managerConfig) {
        this.redisTemplate = redisTemplate;
        this.managerConfig = managerConfig;
    }

    @Override
    public void createGroup(String groupId) {
        this.redisTemplate.opsForList().leftPush((Object)(REDIS_PREFIX + groupId), (Object)"tx.starter");
        this.redisTemplate.expire((Object)(REDIS_PREFIX + groupId), this.managerConfig.getDtxTime() + 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void joinGroup(String groupId, TransUnit transUnit) throws JoinGroupException {
        if (Optional.ofNullable(this.redisTemplate.hasKey((Object)(REDIS_PREFIX + groupId))).orElse(false).booleanValue()) {
            this.redisTemplate.opsForList().rightPush((Object)(REDIS_PREFIX + groupId), (Object)JSON.toJSONString((Object)transUnit));
            return;
        }
        log.warn("attempts to join non-existent transaction group:{} !", (Object)groupId);
        throw new JoinGroupException("attempts to join non-existent transaction group " + groupId);
    }

    @Override
    public List<TransUnit> unitsOfGroup(String groupId) {
        Long size = this.redisTemplate.opsForList().size((Object)(REDIS_PREFIX + groupId));
        if (Objects.isNull(size)) {
            throw new IllegalStateException("non exists this group.");
        }
        List units = this.redisTemplate.opsForList().range((Object)(REDIS_PREFIX + groupId), 1L, size.longValue());
        if (Objects.isNull(units)) {
            throw new IllegalStateException("non exists this group.");
        }
        log.debug("transaction units: {}", (Object)units);
        ArrayList<TransUnit> transUnits = new ArrayList<TransUnit>(units.size());
        units.forEach(unit -> transUnits.add((TransUnit)JSON.parseObject((String)unit, TransUnit.class)));
        return transUnits;
    }

    @Override
    public void removeGroup(String groupId) {
        log.debug("remove group:{} from redis.", (Object)groupId);
        this.redisTemplate.delete((Object)(REDIS_PREFIX + groupId));
    }

    @Override
    public void setTransactionState(String groupId, int state) {
        this.redisTemplate.opsForValue().set((Object)(REDIS_GROUP_STATE + groupId), (Object)String.valueOf(state));
        this.redisTemplate.expire((Object)(REDIS_GROUP_STATE + groupId), this.managerConfig.getDtxTime() + 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Short transactionState(String groupId) {
        String state = (String)this.redisTemplate.opsForValue().get((Object)(REDIS_GROUP_STATE + groupId));
        if (Objects.isNull(state)) {
            return (short)-1;
        }
        try {
            return Short.valueOf(state);
        }
        catch (Exception e) {
            return (short)0;
        }
    }
}

