/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.db.redis;

import com.codingapi.txlcn.manager.config.TxManagerConfig;
import com.codingapi.txlcn.manager.db.ManagerStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisManagerStorage
implements ManagerStorage,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RedisManagerStorage.class);
    private static final String REDIS_PREFIX = "tx.manager.list";
    private final RedisTemplate<String, String> redisTemplate;
    private final TxManagerConfig managerConfig;
    private int port;

    @Autowired
    public RedisManagerStorage(RedisTemplate<String, String> redisTemplate, TxManagerConfig managerConfig, ServerProperties serverProperties) {
        this.redisTemplate = redisTemplate;
        this.managerConfig = managerConfig;
        this.port = Objects.requireNonNull(serverProperties.getPort(), "TM http port not configured ?");
    }

    private boolean add(String address) {
        List<String> list = this.list();
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (list.contains(address)) {
            return false;
        }
        list.add(address);
        this.save(list);
        return true;
    }

    private void save(List<String> list) {
        CharSequence[] array = list.toArray(new String[list.size()]);
        String addressList = String.join((CharSequence)",", array);
        this.redisTemplate.opsForValue().set((Object)REDIS_PREFIX, (Object)addressList);
    }

    private List<String> list() {
        String addressList = (String)this.redisTemplate.opsForValue().get((Object)REDIS_PREFIX);
        if (addressList == null) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(addressList.split(",")));
    }

    @Override
    public List<String> addressList() {
        List<String> list = this.list();
        if (list == null) {
            return null;
        }
        String address = this.managerConfig.getHost() + ":" + this.port;
        list.remove(address);
        return list;
    }

    @Override
    public void remove(String address) {
        List<String> list = this.list();
        list.remove(address);
        if (list.size() == 0) {
            this.redisTemplate.delete((Object)REDIS_PREFIX);
        } else {
            this.save(list);
        }
    }

    public void init() throws Exception {
        String address = this.managerConfig.getHost() + ":" + this.port;
        this.add(address);
        log.info("manager add redis finish.");
    }

    public void destroy() throws Exception {
        String address = this.managerConfig.getHost() + ":" + this.port;
        this.remove(address);
        log.info("manager remove redis.");
    }
}

