/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.db.redis;

import com.codingapi.txlcn.manager.support.restapi.auth.sauth.token.TokenStorage;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisTokenStorage
implements TokenStorage {
    private static final String REDIS_PREFIX = "tx.manager:token";
    private final RedisTemplate<String, String> redisTemplate;

    @Autowired
    public RedisTokenStorage(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean exist(String token) {
        Long size = this.redisTemplate.opsForList().size((Object)REDIS_PREFIX);
        if (Objects.isNull(size)) {
            return false;
        }
        List tokens = this.redisTemplate.opsForList().range((Object)REDIS_PREFIX, 0L, size.longValue());
        return tokens.contains(token);
    }

    @Override
    public void add(String token) {
        Objects.requireNonNull(token);
        Long size = this.redisTemplate.opsForList().size((Object)REDIS_PREFIX);
        this.redisTemplate.opsForList().leftPush((Object)REDIS_PREFIX, (Object)token);
        this.redisTemplate.expire((Object)REDIS_PREFIX, 20L, TimeUnit.MINUTES);
        if (Objects.nonNull(size) && size > 3L) {
            this.redisTemplate.opsForList().rightPop((Object)REDIS_PREFIX);
        }
    }

    @Override
    public void remove(String token) {
        throw new IllegalStateException("not support");
    }

    @Override
    public void clear() {
        this.redisTemplate.delete((Object)REDIS_PREFIX);
    }
}

