/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.support;

import com.codingapi.txlcn.manager.config.TxManagerConfig;
import com.codingapi.txlcn.manager.db.ManagerStorage;
import com.codingapi.txlcn.spi.message.params.NotifyConnectParams;
import java.net.ConnectException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class TxManagerAutoCluster {
    private static final Logger log = LoggerFactory.getLogger(TxManagerAutoCluster.class);
    private final ManagerStorage managerStorage;
    private final RestTemplate restTemplate;
    private final TxManagerConfig txManagerConfig;
    private static final String MANAGER_REFRESH_URL = "http://%s/manager/refresh";

    @Autowired
    public TxManagerAutoCluster(ManagerStorage managerStorage, RestTemplate restTemplate, TxManagerConfig txManagerConfig) {
        this.managerStorage = managerStorage;
        this.restTemplate = restTemplate;
        this.txManagerConfig = txManagerConfig;
    }

    public void refresh() {
        NotifyConnectParams notifyConnectParams = new NotifyConnectParams();
        notifyConnectParams.setHost(this.txManagerConfig.getHost());
        notifyConnectParams.setPort(this.txManagerConfig.getPort());
        List<String> addressList = this.managerStorage.addressList();
        log.info("Manager AddressList->{}", addressList);
        for (String address : addressList) {
            String url = String.format(MANAGER_REFRESH_URL, address);
            try {
                ResponseEntity res = this.restTemplate.postForEntity(url, (Object)notifyConnectParams, Boolean.class, new Object[0]);
                if (res.getStatusCode().equals((Object)HttpStatus.OK) || res.getStatusCode().is5xxServerError()) {
                    log.info("manager auto refresh res->{}", (Object)res);
                    continue;
                }
                this.managerStorage.remove(address);
            }
            catch (Exception e) {
                ResourceAccessException resourceAccessException;
                log.error("manager auto refresh error ");
                if (!(e instanceof ResourceAccessException) || (resourceAccessException = (ResourceAccessException)e).getCause() == null || !(resourceAccessException.getCause() instanceof ConnectException)) continue;
                this.managerStorage.remove(address);
            }
        }
    }
}

