/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.support.restapi;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.txlcn.commons.exception.TransactionStateException;
import com.codingapi.txlcn.commons.exception.TxManagerException;
import com.codingapi.txlcn.manager.support.restapi.model.DeleteExceptions;
import com.codingapi.txlcn.manager.support.restapi.model.DeleteLogsReq;
import com.codingapi.txlcn.manager.support.restapi.model.ExceptionList;
import com.codingapi.txlcn.manager.support.restapi.model.ListAppMods;
import com.codingapi.txlcn.manager.support.restapi.model.Token;
import com.codingapi.txlcn.manager.support.restapi.model.TxLogList;
import com.codingapi.txlcn.manager.support.restapi.model.TxManagerInfo;
import com.codingapi.txlcn.manager.support.service.AdminService;
import com.codingapi.txlcn.manager.support.service.TxExceptionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin"})
public class AdminController {
    private final AdminService adminService;
    private final TxExceptionService txExceptionService;

    @Autowired
    public AdminController(AdminService adminService, TxExceptionService txExceptionService) {
        this.adminService = adminService;
        this.txExceptionService = txExceptionService;
    }

    @PostMapping(value={"/login"})
    public Token login(@RequestParam(value="password") String password) throws TxManagerException {
        return new Token(this.adminService.login(password));
    }

    @GetMapping(value={"/exceptions/{page}", "/exceptions", "/exceptions/{page}/{limit}"})
    public ExceptionList exceptionList(@RequestParam(value="page", required=false) @PathVariable(value="page", required=false) Integer page, @RequestParam(value="limit", required=false) @PathVariable(value="limit", required=false) Integer limit, @RequestParam(value="extState", required=false) Integer extState, @RequestParam(value="registrar", required=false) Integer registrar) {
        return this.txExceptionService.exceptionList(page, limit, extState, null, registrar);
    }

    @PostMapping(value={"/exceptions"})
    public boolean deleteExceptions(@RequestBody DeleteExceptions deleteExceptions) throws TxManagerException {
        this.txExceptionService.deleteExceptions(deleteExceptions.getId());
        return true;
    }

    @GetMapping(value={"/log/transaction-info"})
    public JSONObject transactionInfo(@RequestParam(value="groupId") String groupId, @RequestParam(value="unitId") String unitId) throws TxManagerException {
        try {
            return this.txExceptionService.getTransactionInfo(groupId, unitId);
        }
        catch (TransactionStateException e) {
            throw new TxManagerException((Throwable)e);
        }
    }

    @GetMapping(value={"/logs/{page}", "/logs/{page}/{limit}", "/logs"})
    public TxLogList txLogList(@RequestParam(value="page", required=false) @PathVariable(value="page", required=false) Integer page, @RequestParam(value="limit", required=false) @PathVariable(value="limit", required=false) Integer limit, @RequestParam(value="groupId", required=false) String groupId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="ld", required=false) String lTime, @RequestParam(value="rd", required=false) String rTime, @RequestParam(value="timeOrder", required=false) Integer timeOrder) throws TxManagerException {
        return this.adminService.txLogList(page, limit, groupId, tag, lTime, rTime, timeOrder);
    }

    @GetMapping(value={"/app-mods/{page}", "/app-mods/{page}/{limit}", "/app-mods"})
    public ListAppMods listAppMods(@PathVariable(value="page", required=false) @RequestParam(value="page", required=false) Integer page, @PathVariable(value="limit", required=false) @RequestParam(value="limit", required=false) Integer limit) {
        return this.adminService.listAppMods(page, limit);
    }

    @DeleteMapping(value={"/logs"})
    public boolean deleteLogs(@RequestBody DeleteLogsReq deleteLogsReq) throws TxManagerException {
        this.adminService.deleteLogs(deleteLogsReq);
        return true;
    }

    @GetMapping(value={"/tx-manager"})
    public TxManagerInfo getTxManagerInfo() {
        return this.adminService.getTxManagerInfo();
    }
}

