/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.txlcn.commons.exception.TransactionStateException;
import com.codingapi.txlcn.commons.exception.TxManagerException;
import com.codingapi.txlcn.manager.core.message.MessageCreator;
import com.codingapi.txlcn.manager.db.domain.TxException;
import com.codingapi.txlcn.manager.db.mybatis.TxExceptionMapper;
import com.codingapi.txlcn.manager.support.restapi.model.ExceptionInfo;
import com.codingapi.txlcn.manager.support.restapi.model.ExceptionList;
import com.codingapi.txlcn.manager.support.service.TxExceptionService;
import com.codingapi.txlcn.manager.support.service.WriteTxExceptionDTO;
import com.codingapi.txlcn.manager.support.txex.TxExceptionListener;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import com.codingapi.txlcn.spi.message.util.MessageUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxExceptionServiceImpl
implements TxExceptionService {
    private static final Logger log = LoggerFactory.getLogger(TxExceptionServiceImpl.class);
    private final TxExceptionMapper txExceptionMapper;
    private final RpcClient rpcClient;
    private final TxExceptionListener txExceptionListener;

    @Autowired
    public TxExceptionServiceImpl(TxExceptionMapper txExceptionMapper, RpcClient rpcClient, TxExceptionListener txExceptionListener) {
        this.txExceptionMapper = txExceptionMapper;
        this.rpcClient = rpcClient;
        this.txExceptionListener = txExceptionListener;
    }

    @Override
    public void writeTxException(WriteTxExceptionDTO writeTxExceptionReq) {
        log.info("write tx_exception.");
        TxException txException = new TxException();
        txException.setCreateTime(new Date());
        txException.setGroupId(writeTxExceptionReq.getGroupId());
        txException.setTransactionState(writeTxExceptionReq.getTransactionState());
        txException.setUnitId(writeTxExceptionReq.getUnitId());
        txException.setRegistrar(writeTxExceptionReq.getRegistrar());
        txException.setModId(writeTxExceptionReq.getModId());
        txException.setExState((short)0);
        this.txExceptionMapper.save(txException);
        this.txExceptionListener.onException(txException);
    }

    @Override
    public int transactionState(String groupId) {
        log.debug("transactionState > groupId: {}", (Object)groupId);
        Integer state = this.txExceptionMapper.getTransactionStateByGroupId(groupId);
        if (Objects.isNull(state)) {
            return -1;
        }
        return state;
    }

    @Override
    public ExceptionList exceptionList(Integer page, Integer limit, Integer exState, String keyword, Integer registrar) {
        if (Objects.isNull(page) || page <= 0) {
            page = 1;
        }
        if (Objects.isNull(limit) || limit < 1) {
            limit = 10;
        }
        Page pageInfo = PageHelper.startPage((int)page, (int)limit, (boolean)true);
        List<TxException> txExceptions = Objects.nonNull(exState) && exState != -2 && Objects.nonNull(registrar) && registrar != -2 ? this.txExceptionMapper.findByExStateAndRegistrar(exState, registrar) : (Objects.nonNull(exState) && exState != -2 ? this.txExceptionMapper.findByExState(exState) : (Objects.nonNull(registrar) && registrar != -2 ? this.txExceptionMapper.findByRegistrar(registrar) : this.txExceptionMapper.findAll()));
        ArrayList<ExceptionInfo> exceptionInfoList = new ArrayList<ExceptionInfo>(txExceptions.size());
        for (TxException txException : txExceptions) {
            ExceptionInfo exceptionInfo;
            block6: {
                exceptionInfo = new ExceptionInfo();
                BeanUtils.copyProperties((Object)txException, (Object)exceptionInfo);
                if (txException.getExState() != 1) {
                    try {
                        JSONObject transactionInfo = this.getTransactionInfo(exceptionInfo.getGroupId(), exceptionInfo.getUnitId());
                        exceptionInfo.setTransactionInfo(transactionInfo);
                    }
                    catch (TransactionStateException e) {
                        if (e.getCode() != 11) break block6;
                        this.txExceptionMapper.changeExState(txException.getId(), (short)1);
                        exceptionInfo.setExState((short)1);
                    }
                }
            }
            exceptionInfoList.add(exceptionInfo);
        }
        ExceptionList exceptionList = new ExceptionList();
        exceptionList.setTotal(pageInfo.getTotal());
        exceptionList.setExceptions(exceptionInfoList);
        return exceptionList;
    }

    @Override
    public JSONObject getTransactionInfo(String groupId, String unitId) throws TransactionStateException {
        TxException exception = this.txExceptionMapper.getByGroupAndUnitId(groupId, unitId);
        if (Objects.isNull(exception)) {
            throw new TransactionStateException("non exists aspect log", 11);
        }
        List remoteKeys = this.rpcClient.remoteKeys(exception.getModId());
        if (remoteKeys.isEmpty()) {
            throw new TransactionStateException("non mod found", 10);
        }
        try {
            for (String remoteKey : remoteKeys) {
                MessageDto messageDto = this.rpcClient.request(remoteKey, MessageCreator.getAspectLog(groupId, unitId));
                if (!MessageUtils.statusOk((MessageDto)messageDto)) continue;
                return (JSONObject)messageDto.loadBean(JSONObject.class);
            }
            throw new TransactionStateException("non exists aspect log", 11);
        }
        catch (RpcException e) {
            throw new TransactionStateException((Throwable)e, 12);
        }
    }

    @Override
    public void deleteExceptions(List<Long> ids) throws TxManagerException {
        this.txExceptionMapper.deleteByIdList(ids);
    }
}

