/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.support.txex.provider;

import com.alibaba.fastjson.JSON;
import com.codingapi.txlcn.manager.config.TxManagerConfig;
import com.codingapi.txlcn.manager.db.domain.TxException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DefaultExUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultExUrlProvider.class);
    private final MailProperties mailProperties;
    private final JavaMailSender javaMailSender;

    public DefaultExUrlProvider(@Autowired(required=false) JavaMailSender javaMailSender, @Autowired(required=false) MailProperties mailProperties, @Autowired TxManagerConfig txManagerConfig) {
        this.javaMailSender = javaMailSender;
        this.mailProperties = mailProperties;
        Objects.requireNonNull(txManagerConfig, "tx-manager config can't be null.");
        if (Objects.isNull(javaMailSender) && txManagerConfig.getExUrl().contains("ujued@qq.com")) {
            txManagerConfig.setExUrlEnabled(false);
        }
    }

    @PostMapping(value={"/provider/email-to/{email}"})
    public boolean email(@PathVariable(value="email") String email, @RequestBody TxException txEx) {
        if (Objects.isNull(this.javaMailSender)) {
            log.error("non admin mail configured. so tx exception not be send to email:" + email);
            return false;
        }
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.mailProperties.getUsername());
        message.setTo(email);
        message.setSubject("TX-LCN Transaction Exception!");
        message.setText(JSON.toJSONString((Object)txEx));
        this.javaMailSender.send(message);
        return true;
    }
}

