/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.common.util.id;

import com.codingapi.txlcn.common.util.id.DefaultIdGen;
import com.codingapi.txlcn.common.util.id.RandomUtils;
import com.codingapi.txlcn.common.util.id.SnowFlakeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdGenInit {
    private static final Logger log = LoggerFactory.getLogger(IdGenInit.class);

    public static void applySnowFlakeIdGen(int machineLen, long machineId) {
        SnowFlakeGenerator.Factory factory = new SnowFlakeGenerator.Factory(machineLen, 0);
        SnowFlakeGenerator snowFlakeGenerator = factory.create(0L, machineId);
        RandomUtils.init(() -> String.valueOf(snowFlakeGenerator.nextId()));
    }

    public static void applyDefaultIdGen(int seqLen, long machineId) {
        RandomUtils.init(new DefaultIdGen(seqLen, machineId));
    }
}

