/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.env.ClusterEnvironment;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncScope {
    private final Core core;
    private final String bucketName;
    private final String scopeName;
    private final ClusterEnvironment environment;
    private final Map<String, AsyncCollection> collectionCache = new ConcurrentHashMap<String, AsyncCollection>();

    AsyncScope(String scopeName, String bucketName, Core core, ClusterEnvironment environment) {
        this.scopeName = scopeName;
        this.bucketName = bucketName;
        this.core = core;
        this.environment = environment;
    }

    public String name() {
        return this.scopeName;
    }

    public String bucketName() {
        return this.bucketName;
    }

    @Stability.Volatile
    public Core core() {
        return this.core;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    AsyncCollection defaultCollection() {
        return this.maybeCreateAsyncCollection("_default", !this.scopeName.equals("_default"));
    }

    @Stability.Volatile
    public AsyncCollection collection(String collectionName) {
        boolean defaultScopeAndCollection = collectionName.equals("_default") && this.scopeName.equals("_default");
        return this.maybeCreateAsyncCollection(collectionName, !defaultScopeAndCollection);
    }

    private AsyncCollection maybeCreateAsyncCollection(String collectionName, boolean refreshMap) {
        return this.collectionCache.computeIfAbsent(collectionName, name -> {
            if (refreshMap) {
                this.core.configurationProvider().refreshCollectionMap(this.bucketName, false);
            }
            return new AsyncCollection((String)name, this.scopeName, this.bucketName, this.core, this.environment);
        });
    }
}

