/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.events.request.IndividualReplicaGetFailedEvent;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.kv.GetAndLockRequest;
import com.couchbase.client.core.msg.kv.GetAndTouchRequest;
import com.couchbase.client.core.msg.kv.GetMetaRequest;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.InsertRequest;
import com.couchbase.client.core.msg.kv.RemoveRequest;
import com.couchbase.client.core.msg.kv.ReplaceRequest;
import com.couchbase.client.core.msg.kv.ReplicaGetRequest;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.TouchRequest;
import com.couchbase.client.core.msg.kv.UnlockRequest;
import com.couchbase.client.core.msg.kv.UpsertRequest;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.ReactiveBinaryCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.kv.ExistsAccessor;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import com.couchbase.client.java.kv.GetAccessor;
import com.couchbase.client.java.kv.GetAllReplicasOptions;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetReplicaResult;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertAccessor;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInAccessor;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInAccessor;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.RemoveAccessor;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceAccessor;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.StoreSemantics;
import com.couchbase.client.java.kv.TouchAccessor;
import com.couchbase.client.java.kv.TouchOptions;
import com.couchbase.client.java.kv.UnlockAccessor;
import com.couchbase.client.java.kv.UnlockOptions;
import com.couchbase.client.java.kv.UpsertAccessor;
import com.couchbase.client.java.kv.UpsertOptions;
import java.time.Duration;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCollection {
    static final ExistsOptions DEFAULT_EXISTS_OPTIONS = ExistsOptions.existsOptions();
    static final GetAndLockOptions DEFAULT_GET_AND_LOCK_OPTIONS = GetAndLockOptions.getAndLockOptions();
    static final GetAndTouchOptions DEFAULT_GET_AND_TOUCH_OPTIONS = GetAndTouchOptions.getAndTouchOptions();
    static final GetAllReplicasOptions DEFAULT_GET_ALL_REPLICAS_OPTIONS = GetAllReplicasOptions.getAllReplicasOptions();
    static final GetAnyReplicaOptions DEFAULT_GET_ANY_REPLICA_OPTIONS = GetAnyReplicaOptions.getAnyReplicaOptions();
    static final GetOptions DEFAULT_GET_OPTIONS = GetOptions.getOptions();
    static final InsertOptions DEFAULT_INSERT_OPTIONS = InsertOptions.insertOptions();
    static final LookupInOptions DEFAULT_LOOKUP_IN_OPTIONS = LookupInOptions.lookupInOptions();
    static final MutateInOptions DEFAULT_MUTATE_IN_OPTIONS = MutateInOptions.mutateInOptions();
    static final RemoveOptions DEFAULT_REMOVE_OPTIONS = RemoveOptions.removeOptions();
    static final ReplaceOptions DEFAULT_REPLACE_OPTIONS = ReplaceOptions.replaceOptions();
    static final TouchOptions DEFAULT_TOUCH_OPTIONS = TouchOptions.touchOptions();
    static final UnlockOptions DEFAULT_UNLOCK_OPTIONS = UnlockOptions.unlockOptions();
    static final UpsertOptions DEFAULT_UPSERT_OPTIONS = UpsertOptions.upsertOptions();
    private final AsyncCollection asyncCollection;
    private final CoreContext coreContext;
    private final Core core;
    private final ReactiveBinaryCollection reactiveBinaryCollection;

    ReactiveCollection(AsyncCollection asyncCollection) {
        this.asyncCollection = asyncCollection;
        this.coreContext = asyncCollection.core().context();
        this.core = asyncCollection.core();
        this.reactiveBinaryCollection = new ReactiveBinaryCollection(this.core, asyncCollection.binary());
    }

    public AsyncCollection async() {
        return this.asyncCollection;
    }

    public String name() {
        return this.asyncCollection.name();
    }

    public String bucketName() {
        return this.asyncCollection.bucketName();
    }

    public String scopeName() {
        return this.asyncCollection.scopeName();
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncCollection.core();
    }

    public ClusterEnvironment environment() {
        return this.asyncCollection.environment();
    }

    public ReactiveBinaryCollection binary() {
        return this.reactiveBinaryCollection;
    }

    public Mono<GetResult> get(String id) {
        return this.get(id, DEFAULT_GET_OPTIONS);
    }

    public Mono<GetResult> get(String id, GetOptions options) {
        return Mono.defer(() -> {
            Transcoder transcoder;
            GetOptions.Built opts = options.build();
            Transcoder transcoder2 = transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
            if (opts.projections().isEmpty() && !opts.withExpiry()) {
                GetRequest request = this.asyncCollection.fullGetRequest(id, opts);
                return Reactor.wrap((Request)request, GetAccessor.get(this.core, request, transcoder), (boolean)true);
            }
            SubdocGetRequest request = this.asyncCollection.subdocGetRequest(id, opts);
            return Reactor.wrap((Request)request, GetAccessor.subdocGet(this.core, request, transcoder), (boolean)true);
        });
    }

    public Mono<GetResult> getAndLock(String id, Duration lockTime) {
        return this.getAndLock(id, lockTime, DEFAULT_GET_AND_LOCK_OPTIONS);
    }

    public Mono<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        return Mono.defer(() -> {
            GetAndLockOptions.Built opts = options.build();
            Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
            GetAndLockRequest request = this.asyncCollection.getAndLockRequest(id, lockTime, opts);
            return Reactor.wrap((Request)request, GetAccessor.getAndLock(this.core, request, transcoder), (boolean)true);
        });
    }

    public Mono<GetResult> getAndTouch(String id, Duration expiry) {
        return this.getAndTouch(id, expiry, DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public Mono<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return Mono.defer(() -> {
            GetAndTouchOptions.Built opts = options.build();
            Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
            GetAndTouchRequest request = this.asyncCollection.getAndTouchRequest(id, expiry, opts);
            return Reactor.wrap((Request)request, GetAccessor.getAndTouch(this.core, request, transcoder), (boolean)true);
        });
    }

    public Flux<GetReplicaResult> getAllReplicas(String id) {
        return this.getAllReplicas(id, DEFAULT_GET_ALL_REPLICAS_OPTIONS);
    }

    public Flux<GetReplicaResult> getAllReplicas(String id, GetAllReplicasOptions options) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)options, (String)"GetAllReplicasOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        GetAllReplicasOptions.Built opts = options.build();
        Duration timeout = opts.timeout().orElse(this.environment().timeoutConfig().kvTimeout());
        RequestSpan parent = this.environment().requestTracer().requestSpan("get_all_replicas", (RequestSpan)opts.parentSpan().orElse(null));
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return Reactor.toMono(() -> this.asyncCollection.getAllReplicasRequests(id, opts, timeout, parent)).flux().flatMap(Flux::fromStream).flatMap(request -> Reactor.wrap((Request)request, GetAccessor.get(this.core, request, transcoder), (boolean)true).onErrorResume(t -> {
            this.coreContext.environment().eventBus().publish((Event)new IndividualReplicaGetFailedEvent(request.context()));
            return Mono.empty();
        }).map(response -> GetReplicaResult.from(response, request instanceof ReplicaGetRequest))).doFinally(signalType -> parent.finish());
    }

    public Mono<GetReplicaResult> getAnyReplica(String id) {
        return this.getAnyReplica(id, DEFAULT_GET_ANY_REPLICA_OPTIONS);
    }

    public Mono<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        GetAnyReplicaOptions.Built built = options.build();
        GetAllReplicasOptions opts = (GetAllReplicasOptions)GetAllReplicasOptions.getAllReplicasOptions().clientContext(built.clientContext());
        built.timeout().ifPresent(opts::timeout);
        built.retryStrategy().ifPresent(opts::retryStrategy);
        if (built.transcoder() != null) {
            opts.transcoder(built.transcoder());
        }
        RequestSpan parent = this.environment().requestTracer().requestSpan("get_any_replica", (RequestSpan)built.parentSpan().orElse(null));
        opts.parentSpan(parent);
        return this.getAllReplicas(id, opts).next().doFinally(signalType -> parent.finish());
    }

    public Mono<ExistsResult> exists(String id) {
        return this.exists(id, DEFAULT_EXISTS_OPTIONS);
    }

    public Mono<ExistsResult> exists(String id, ExistsOptions options) {
        return Mono.defer(() -> {
            GetMetaRequest request = this.asyncCollection.existsRequest(id, options);
            return Reactor.wrap((Request)request, ExistsAccessor.exists(id, this.core, request), (boolean)true);
        });
    }

    public Mono<MutationResult> remove(String id) {
        return this.remove(id, DEFAULT_REMOVE_OPTIONS);
    }

    public Mono<MutationResult> remove(String id, RemoveOptions options) {
        return Mono.defer(() -> {
            Validators.notNull((Object)options, (String)"RemoveOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
            RemoveOptions.Built opts = options.build();
            RemoveRequest request = this.asyncCollection.removeRequest(id, opts);
            return Reactor.wrap((Request)request, RemoveAccessor.remove(this.core, request, id, opts.persistTo(), opts.replicateTo()), (boolean)true);
        });
    }

    public Mono<MutationResult> insert(String id, Object content) {
        return this.insert(id, content, DEFAULT_INSERT_OPTIONS);
    }

    public Mono<MutationResult> insert(String id, Object content, InsertOptions options) {
        return Mono.defer(() -> {
            Validators.notNull((Object)options, (String)"InsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
            InsertOptions.Built opts = options.build();
            InsertRequest request = this.asyncCollection.insertRequest(id, content, opts);
            return Reactor.wrap((Request)request, InsertAccessor.insert(this.core, request, id, opts.persistTo(), opts.replicateTo()), (boolean)true);
        });
    }

    public Mono<MutationResult> upsert(String id, Object content) {
        return this.upsert(id, content, DEFAULT_UPSERT_OPTIONS);
    }

    public Mono<MutationResult> upsert(String id, Object content, UpsertOptions options) {
        return Mono.defer(() -> {
            Validators.notNull((Object)options, (String)"UpsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
            UpsertOptions.Built opts = options.build();
            UpsertRequest request = this.asyncCollection.upsertRequest(id, content, opts);
            return Reactor.wrap((Request)request, UpsertAccessor.upsert(this.core, request, id, opts.persistTo(), opts.replicateTo()), (boolean)true);
        });
    }

    public Mono<MutationResult> replace(String id, Object content) {
        return this.replace(id, content, DEFAULT_REPLACE_OPTIONS);
    }

    public Mono<MutationResult> replace(String id, Object content, ReplaceOptions options) {
        return Mono.defer(() -> {
            Validators.notNull((Object)options, (String)"ReplaceOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
            ReplaceOptions.Built opts = options.build();
            ReplaceRequest request = this.asyncCollection.replaceRequest(id, content, opts);
            return Reactor.wrap((Request)request, ReplaceAccessor.replace(this.core, request, id, opts.persistTo(), opts.replicateTo()), (boolean)true);
        });
    }

    public Mono<MutationResult> touch(String id, Duration expiry) {
        return this.touch(id, expiry, DEFAULT_TOUCH_OPTIONS);
    }

    public Mono<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        return Mono.defer(() -> {
            TouchRequest request = this.asyncCollection.touchRequest(id, expiry, options);
            return Reactor.wrap((Request)request, TouchAccessor.touch(this.core, request, id), (boolean)true);
        });
    }

    public Mono<Void> unlock(String id, long cas) {
        return this.unlock(id, cas, DEFAULT_UNLOCK_OPTIONS);
    }

    public Mono<Void> unlock(String id, long cas, UnlockOptions options) {
        return Mono.defer(() -> {
            UnlockRequest request = this.asyncCollection.unlockRequest(id, cas, options);
            return Reactor.wrap((Request)request, UnlockAccessor.unlock(id, this.core, request), (boolean)true);
        });
    }

    public Mono<LookupInResult> lookupIn(String id, List<LookupInSpec> specs) {
        return this.lookupIn(id, specs, DEFAULT_LOOKUP_IN_OPTIONS);
    }

    public Mono<LookupInResult> lookupIn(String id, List<LookupInSpec> specs, LookupInOptions options) {
        return Mono.defer(() -> {
            Validators.notNull((Object)options, (String)"LookupInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
            LookupInOptions.Built opts = options.build();
            JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
            SubdocGetRequest request = this.asyncCollection.lookupInRequest(id, specs, opts);
            return Reactor.wrap((Request)request, LookupInAccessor.lookupInAccessor(this.core, request, serializer), (boolean)true);
        });
    }

    public Mono<MutateInResult> mutateIn(String id, List<MutateInSpec> specs) {
        return this.mutateIn(id, specs, DEFAULT_MUTATE_IN_OPTIONS);
    }

    public Mono<MutateInResult> mutateIn(String id, List<MutateInSpec> specs, MutateInOptions options) {
        return Mono.defer(() -> {
            Validators.notNull((Object)options, (String)"MutateInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
            MutateInOptions.Built opts = options.build();
            Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment().timeoutConfig());
            return Mono.fromFuture(this.asyncCollection.mutateInRequest(id, specs, opts, timeout)).flatMap(request -> Reactor.wrap((Request)request, MutateInAccessor.mutateIn(this.core, request, id, opts.persistTo(), opts.replicateTo(), opts.storeSemantics() == StoreSemantics.INSERT, this.environment().jsonSerializer()), (boolean)true));
        });
    }
}

