/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncScope;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.env.ClusterEnvironment;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Stability.Volatile
public class Scope {
    private final AsyncScope asyncScope;
    private final Map<String, Collection> collectionCache = new ConcurrentHashMap<String, Collection>();

    Scope(AsyncScope asyncScope) {
        this.asyncScope = asyncScope;
    }

    public String name() {
        return this.asyncScope.name();
    }

    public String bucketName() {
        return this.asyncScope.bucketName();
    }

    public AsyncScope async() {
        return this.asyncScope;
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncScope.core();
    }

    public ClusterEnvironment environment() {
        return this.asyncScope.environment();
    }

    Collection defaultCollection() {
        return this.collectionCache.computeIfAbsent("_default", n -> new Collection(this.asyncScope.defaultCollection()));
    }

    @Stability.Volatile
    public Collection collection(String collectionName) {
        return this.collectionCache.computeIfAbsent(collectionName, n -> new Collection(this.asyncScope.collection((String)n)));
    }
}

