/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SubdocMutateRequest;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.kv.DurabilityUtils;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class MutateInAccessor {
    public static CompletableFuture<MutateInResult> mutateIn(Core core, SubdocMutateRequest request, String key, PersistTo persistTo, ReplicateTo replicateTo, Boolean insertDocument, JsonSerializer serializer) {
        core.send((Request)request);
        CompletionStage mutateInResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new MutateInResult(response.values(), response.cas(), response.mutationToken(), serializer);
            }
            KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest((KeyValueRequest)request, (ResponseStatus)response.status());
            if (insertDocument.booleanValue() && response.status() == ResponseStatus.EXISTS) {
                throw new DocumentExistsException((ErrorContext)ctx);
            }
            if (response.status() == ResponseStatus.SUBDOC_FAILURE && response.error().isPresent()) {
                throw (CouchbaseException)response.error().get();
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        });
        return DurabilityUtils.wrapWithDurability(mutateInResult, key, persistTo, replicateTo, core, request, false);
    }
}

