/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.manager.analytics.AnalyticsDataType;
import com.couchbase.client.java.manager.analytics.AnalyticsDataset;
import com.couchbase.client.java.manager.analytics.AnalyticsDataverse;
import com.couchbase.client.java.manager.analytics.AnalyticsIndex;
import com.couchbase.client.java.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.java.manager.analytics.ConnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DisconnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllDatasetsAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllIndexesAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetPendingMutationsAnalyticsOptions;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAnalyticsIndexManager {
    private final AsyncAnalyticsIndexManager async;

    public ReactiveAnalyticsIndexManager(AsyncCluster cluster) {
        this.async = new AsyncAnalyticsIndexManager(cluster);
    }

    public Mono<Void> createDataverse(String dataverseName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createDataverse(dataverseName)));
    }

    public Mono<Void> createDataverse(String dataverseName, CreateDataverseAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createDataverse(dataverseName, options)));
    }

    public Mono<Void> dropDataverse(String dataverseName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropDataverse(dataverseName)));
    }

    public Mono<Void> dropDataverse(String dataverseName, DropDataverseAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropDataverse(dataverseName, options)));
    }

    public Flux<AnalyticsDataverse> getAllDataverses() {
        return Flux.defer(() -> Reactor.toFlux(this.async::getAllDataverses));
    }

    public Mono<Void> createDataset(String datasetName, String bucketName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createDataset(datasetName, bucketName)));
    }

    public Mono<Void> createDataset(String datasetName, String bucketName, CreateDatasetAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createDataset(datasetName, bucketName, options)));
    }

    public Mono<Void> dropDataset(String datasetName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropDataset(datasetName)));
    }

    public Mono<Void> dropDataset(String datasetName, DropDatasetAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropDataset(datasetName, options)));
    }

    public Flux<AnalyticsDataset> getAllDatasets() {
        return Flux.defer(() -> Reactor.toFlux(this.async::getAllDatasets));
    }

    public Flux<AnalyticsDataset> getAllDatasets(GetAllDatasetsAnalyticsOptions options) {
        return Flux.defer(() -> Reactor.toFlux(() -> this.async.getAllDatasets(options)));
    }

    public Mono<Void> createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createIndex(indexName, datasetName, fields)));
    }

    public Mono<Void> createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields, CreateIndexAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createIndex(indexName, datasetName, fields, options)));
    }

    public Mono<Void> dropIndex(String indexName, String datasetName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropIndex(indexName, datasetName)));
    }

    public Mono<Void> dropIndex(String indexName, String datasetName, DropIndexAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropIndex(indexName, datasetName, options)));
    }

    public Flux<AnalyticsIndex> getAllIndexes() {
        return Flux.defer(() -> Reactor.toFlux(this.async::getAllIndexes));
    }

    public Flux<AnalyticsIndex> getAllIndexes(GetAllIndexesAnalyticsOptions options) {
        return Flux.defer(() -> Reactor.toFlux(() -> this.async.getAllIndexes(options)));
    }

    public Mono<Void> connectLink() {
        return Mono.defer(() -> Reactor.toMono(this.async::connectLink));
    }

    public Mono<Void> connectLink(ConnectLinkAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.connectLink(options)));
    }

    public Mono<Void> disconnectLink() {
        return Mono.defer(() -> Reactor.toMono(this.async::disconnectLink));
    }

    public Mono<Void> disconnectLink(DisconnectLinkAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.disconnectLink(options)));
    }

    public Mono<Map<String, Long>> getPendingMutations() {
        return Mono.defer(() -> Reactor.toMono(this.async::getPendingMutations));
    }

    public Mono<Map<String, Long>> getPendingMutations(GetPendingMutationsAnalyticsOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.getPendingMutations(options)));
    }
}

