/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.java.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveQueryIndexManager {
    private final AsyncQueryIndexManager async;

    public ReactiveQueryIndexManager(AsyncQueryIndexManager async) {
        this.async = Objects.requireNonNull(async);
    }

    public Mono<Void> createIndex(String bucketName, String indexName, Collection<String> fields) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createIndex(bucketName, indexName, fields)));
    }

    public Mono<Void> createIndex(String bucketName, String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createIndex(bucketName, indexName, fields, options)));
    }

    public Mono<Void> createPrimaryIndex(String bucketName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createPrimaryIndex(bucketName)));
    }

    public Mono<Void> createPrimaryIndex(String bucketName, CreatePrimaryQueryIndexOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.createPrimaryIndex(bucketName, options)));
    }

    public Flux<QueryIndex> getAllIndexes(String bucketName) {
        return Flux.defer(() -> Reactor.toFlux(() -> this.async.getAllIndexes(bucketName)));
    }

    public Flux<QueryIndex> getAllIndexes(String bucketName, GetAllQueryIndexesOptions options) {
        return Flux.defer(() -> Reactor.toFlux(() -> this.async.getAllIndexes(bucketName, options)));
    }

    public Mono<Void> dropPrimaryIndex(String bucketName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropPrimaryIndex(bucketName)));
    }

    public Mono<Void> dropPrimaryIndex(String bucketName, DropPrimaryQueryIndexOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropPrimaryIndex(bucketName, options)));
    }

    public Mono<Void> dropIndex(String bucketName, String indexName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropIndex(bucketName, indexName)));
    }

    public Mono<Void> dropIndex(String bucketName, String indexName, DropQueryIndexOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.dropIndex(bucketName, indexName, options)));
    }

    public Mono<Void> buildDeferredIndexes(String bucketName) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.buildDeferredIndexes(bucketName)));
    }

    public Mono<Void> buildDeferredIndexes(String bucketName, BuildQueryIndexOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.buildDeferredIndexes(bucketName, options)));
    }

    public Mono<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.watchIndexes(bucketName, indexNames, timeout)));
    }

    public Mono<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        return Mono.defer(() -> Reactor.toMono(() -> this.async.watchIndexes(bucketName, indexNames, timeout, options)));
    }
}

