/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.java.manager.user.Role;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
@Stability.Volatile
public class Group {
    private final String name;
    private String description = "";
    private Set<Role> roles = new HashSet<Role>();
    private Optional<String> ldapGroupReference = Optional.empty();

    public Group(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @JsonCreator
    public Group(@JsonProperty(value="id") String name, @JsonProperty(value="description") String description, @JsonProperty(value="roles") Collection<Role> roles, @JsonProperty(value="ldap_group_ref") String ldapGroupReference) {
        this(name);
        this.description(description);
        this.roles(roles);
        this.ldapGroupReference(ldapGroupReference);
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Group description(String description) {
        this.description = CbStrings.nullToEmpty((String)description);
        return this;
    }

    public Set<Role> roles() {
        return this.roles;
    }

    public Group roles(Collection<Role> roles) {
        this.roles = new HashSet<Role>(roles);
        return this;
    }

    public Group roles(Role ... roles) {
        return this.roles(Arrays.asList(roles));
    }

    public Optional<String> ldapGroupReference() {
        return this.ldapGroupReference;
    }

    public Group ldapGroupReference(String ldapGroupReference) {
        this.ldapGroupReference = Optional.ofNullable(CbStrings.emptyToNull((String)ldapGroupReference));
        return this;
    }

    public String toString() {
        return "Group{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", roles=" + this.roles + ", ldapGroupReference=" + this.ldapGroupReference + '}';
    }
}

