/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.queries.BooleanFieldQuery;
import com.couchbase.client.java.search.queries.BooleanQuery;
import com.couchbase.client.java.search.queries.ConjunctionQuery;
import com.couchbase.client.java.search.queries.DateRangeQuery;
import com.couchbase.client.java.search.queries.DisjunctionQuery;
import com.couchbase.client.java.search.queries.DocIdQuery;
import com.couchbase.client.java.search.queries.GeoBoundingBoxQuery;
import com.couchbase.client.java.search.queries.GeoDistanceQuery;
import com.couchbase.client.java.search.queries.MatchAllQuery;
import com.couchbase.client.java.search.queries.MatchNoneQuery;
import com.couchbase.client.java.search.queries.MatchPhraseQuery;
import com.couchbase.client.java.search.queries.MatchQuery;
import com.couchbase.client.java.search.queries.NumericRangeQuery;
import com.couchbase.client.java.search.queries.PhraseQuery;
import com.couchbase.client.java.search.queries.PrefixQuery;
import com.couchbase.client.java.search.queries.QueryStringQuery;
import com.couchbase.client.java.search.queries.RegexpQuery;
import com.couchbase.client.java.search.queries.TermQuery;
import com.couchbase.client.java.search.queries.TermRangeQuery;
import com.couchbase.client.java.search.queries.WildcardQuery;

@Stability.Internal
public abstract class SearchQuery {
    private Double boost;

    protected SearchQuery() {
    }

    public SearchQuery boost(double boost) {
        this.boost = boost;
        return this;
    }

    public void injectParamsAndBoost(JsonObject input) {
        if (this.boost != null) {
            input.put("boost", this.boost);
        }
        this.injectParams(input);
    }

    protected abstract void injectParams(JsonObject var1);

    public JsonObject export() {
        JsonObject result = JsonObject.create();
        this.injectParams(result);
        JsonObject queryJson = JsonObject.create();
        this.injectParamsAndBoost(queryJson);
        return result.put("query", queryJson);
    }

    public String toString() {
        JsonObject json = JsonObject.create();
        this.injectParamsAndBoost(json);
        return json.toString();
    }

    public static QueryStringQuery queryString(String query) {
        return new QueryStringQuery(query);
    }

    public static MatchQuery match(String match) {
        return new MatchQuery(match);
    }

    public static MatchPhraseQuery matchPhrase(String matchPhrase) {
        return new MatchPhraseQuery(matchPhrase);
    }

    public static PrefixQuery prefix(String prefix) {
        return new PrefixQuery(prefix);
    }

    public static RegexpQuery regexp(String regexp) {
        return new RegexpQuery(regexp);
    }

    public static TermRangeQuery termRange() {
        return new TermRangeQuery();
    }

    public static NumericRangeQuery numericRange() {
        return new NumericRangeQuery();
    }

    public static DateRangeQuery dateRange() {
        return new DateRangeQuery();
    }

    public static DisjunctionQuery disjuncts(SearchQuery ... queries) {
        return new DisjunctionQuery(queries);
    }

    public static ConjunctionQuery conjuncts(SearchQuery ... queries) {
        return new ConjunctionQuery(queries);
    }

    public static BooleanQuery booleans() {
        return new BooleanQuery();
    }

    public static WildcardQuery wildcard(String wildcard) {
        return new WildcardQuery(wildcard);
    }

    public static DocIdQuery docId(String ... docIds) {
        return new DocIdQuery(docIds);
    }

    public static BooleanFieldQuery booleanField(boolean value) {
        return new BooleanFieldQuery(value);
    }

    public static TermQuery term(String term) {
        return new TermQuery(term);
    }

    public static PhraseQuery phrase(String ... terms) {
        return new PhraseQuery(terms);
    }

    public static MatchAllQuery matchAll() {
        return new MatchAllQuery();
    }

    public static MatchNoneQuery matchNone() {
        return new MatchNoneQuery();
    }

    public static GeoBoundingBoxQuery geoBoundingBox(double topLeftLon, double topLeftLat, double bottomRightLon, double bottomRightLat) {
        return new GeoBoundingBoxQuery(topLeftLon, topLeftLat, bottomRightLon, bottomRightLat);
    }

    public static GeoDistanceQuery geoDistance(double locationLon, double locationLat, String distance) {
        return new GeoDistanceQuery(locationLon, locationLat, distance);
    }
}

