/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.connversations.message.model;

import com.coze.openapi.client.connversations.message.model.MessageObjectStringType;
import com.coze.openapi.service.utils.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MessageObjectString {
    @JsonProperty(value="type")
    private MessageObjectStringType type;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="file_id")
    private String fileID;
    @JsonProperty(value="file_url")
    private String fileURL;

    public static MessageObjectString buildText(String text) {
        return MessageObjectString.builder().type(MessageObjectStringType.TEXT).text(text).build();
    }

    public static MessageObjectString buildImageByID(String fileID) {
        return MessageObjectString.buildImage(fileID, null);
    }

    public static MessageObjectString buildImageByURL(String fileURL) {
        return MessageObjectString.buildImage(null, fileURL);
    }

    private static MessageObjectString buildImage(String fileID, String fileURL) {
        if (fileID == null && fileURL == null) {
            throw new IllegalArgumentException("file_id or file_url must be specified");
        }
        return MessageObjectString.builder().type(MessageObjectStringType.IMAGE).fileID(fileID).fileURL(fileURL).build();
    }

    public static MessageObjectString buildFileByID(String fileID) {
        return MessageObjectString.buildFile(fileID, null);
    }

    public static MessageObjectString buildFileByURL(String fileURL) {
        return MessageObjectString.buildFile(null, fileURL);
    }

    private static MessageObjectString buildFile(String fileID, String fileURL) {
        if (fileID == null && fileURL == null) {
            throw new IllegalArgumentException("file_id or file_url must be specified");
        }
        return MessageObjectString.builder().type(MessageObjectStringType.FILE).fileID(fileID).fileURL(fileURL).build();
    }

    public static MessageObjectString buildAudio(String fileID, String fileURL) {
        if (fileID == null && fileURL == null) {
            throw new IllegalArgumentException("file_id or file_url must be specified");
        }
        return MessageObjectString.builder().type(MessageObjectStringType.AUDIO).fileID(fileID).fileURL(fileURL).build();
    }

    public String toJson() {
        return Utils.toJson(this);
    }

    public static MessageObjectStringBuilder builder() {
        return new MessageObjectStringBuilder();
    }

    public MessageObjectStringType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getFileID() {
        return this.fileID;
    }

    public String getFileURL() {
        return this.fileURL;
    }

    @JsonProperty(value="type")
    public void setType(MessageObjectStringType type) {
        this.type = type;
    }

    @JsonProperty(value="text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="file_id")
    public void setFileID(String fileID) {
        this.fileID = fileID;
    }

    @JsonProperty(value="file_url")
    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageObjectString)) {
            return false;
        }
        MessageObjectString other = (MessageObjectString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MessageObjectStringType this$type = this.getType();
        MessageObjectStringType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$fileID = this.getFileID();
        String other$fileID = other.getFileID();
        if (this$fileID == null ? other$fileID != null : !this$fileID.equals(other$fileID)) {
            return false;
        }
        String this$fileURL = this.getFileURL();
        String other$fileURL = other.getFileURL();
        return !(this$fileURL == null ? other$fileURL != null : !this$fileURL.equals(other$fileURL));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageObjectString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageObjectStringType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $fileID = this.getFileID();
        result = result * 59 + ($fileID == null ? 43 : $fileID.hashCode());
        String $fileURL = this.getFileURL();
        result = result * 59 + ($fileURL == null ? 43 : $fileURL.hashCode());
        return result;
    }

    public String toString() {
        return "MessageObjectString(type=" + (Object)((Object)this.getType()) + ", text=" + this.getText() + ", fileID=" + this.getFileID() + ", fileURL=" + this.getFileURL() + ")";
    }

    public MessageObjectString() {
    }

    public MessageObjectString(MessageObjectStringType type, String text, String fileID, String fileURL) {
        this.type = type;
        this.text = text;
        this.fileID = fileID;
        this.fileURL = fileURL;
    }

    public static class MessageObjectStringBuilder {
        private MessageObjectStringType type;
        private String text;
        private String fileID;
        private String fileURL;

        MessageObjectStringBuilder() {
        }

        @JsonProperty(value="type")
        public MessageObjectStringBuilder type(MessageObjectStringType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="text")
        public MessageObjectStringBuilder text(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="file_id")
        public MessageObjectStringBuilder fileID(String fileID) {
            this.fileID = fileID;
            return this;
        }

        @JsonProperty(value="file_url")
        public MessageObjectStringBuilder fileURL(String fileURL) {
            this.fileURL = fileURL;
            return this;
        }

        public MessageObjectString build() {
            return new MessageObjectString(this.type, this.text, this.fileID, this.fileURL);
        }

        public String toString() {
            return "MessageObjectString.MessageObjectStringBuilder(type=" + (Object)((Object)this.type) + ", text=" + this.text + ", fileID=" + this.fileID + ", fileURL=" + this.fileURL + ")";
        }
    }
}

