/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.workflows.run.model;

import com.coze.openapi.client.common.BaseResp;
import com.coze.openapi.client.workflows.run.model.WorkflowEventError;
import com.coze.openapi.client.workflows.run.model.WorkflowEventInterrupt;
import com.coze.openapi.client.workflows.run.model.WorkflowEventMessage;
import com.coze.openapi.client.workflows.run.model.WorkflowEventType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class WorkflowEvent
extends BaseResp {
    @JsonProperty(value="id")
    private int id;
    @JsonProperty(value="event")
    private WorkflowEventType event;
    @JsonProperty(value="message")
    private WorkflowEventMessage message;
    @JsonProperty(value="interrupt")
    private WorkflowEventInterrupt interrupt;
    @JsonProperty(value="error")
    private WorkflowEventError error;

    private static WorkflowEvent parseWorkflowEventMessage(Integer id, String data, String logID) {
        WorkflowEventMessage message = WorkflowEventMessage.fromJson(data);
        return ((WorkflowEventBuilder)((BaseResp.BaseRespBuilder)((WorkflowEventBuilder)((WorkflowEventBuilder)WorkflowEvent.builder().id(id)).event(WorkflowEventType.MESSAGE)).message(message)).logID(logID)).build();
    }

    private static WorkflowEvent parseWorkflowEventInterrupt(Integer id, String data, String logID) {
        WorkflowEventInterrupt interrupt = WorkflowEventInterrupt.fromJson(data);
        return ((WorkflowEventBuilder)((BaseResp.BaseRespBuilder)((WorkflowEventBuilder)((WorkflowEventBuilder)WorkflowEvent.builder().id(id)).event(WorkflowEventType.INTERRUPT)).interrupt(interrupt)).logID(logID)).build();
    }

    private static WorkflowEvent parseWorkflowEventError(Integer id, String data, String logID) {
        WorkflowEventError error = WorkflowEventError.fromJson(data);
        return ((WorkflowEventBuilder)((BaseResp.BaseRespBuilder)((WorkflowEventBuilder)((WorkflowEventBuilder)WorkflowEvent.builder().id(id)).event(WorkflowEventType.ERROR)).error(error)).logID(logID)).build();
    }

    private static WorkflowEvent parseWorkflowEventDone(Integer id, String logID) {
        return ((WorkflowEventBuilder)((BaseResp.BaseRespBuilder)((WorkflowEventBuilder)WorkflowEvent.builder().id(id)).event(WorkflowEventType.DONE)).logID(logID)).build();
    }

    public static WorkflowEvent parseEvent(Map<String, String> eventLine, String logID) {
        Integer id = Integer.parseInt(eventLine.get("id"));
        WorkflowEventType event = WorkflowEventType.fromString(eventLine.get("event"));
        String data = eventLine.get("data");
        if (WorkflowEventType.MESSAGE.equals(event)) {
            return WorkflowEvent.parseWorkflowEventMessage(id, data, logID);
        }
        if (WorkflowEventType.INTERRUPT.equals(event)) {
            return WorkflowEvent.parseWorkflowEventInterrupt(id, data, logID);
        }
        if (WorkflowEventType.ERROR.equals(event)) {
            return WorkflowEvent.parseWorkflowEventError(id, data, logID);
        }
        if (WorkflowEventType.DONE.equals(event)) {
            return WorkflowEvent.parseWorkflowEventDone(id, logID);
        }
        return WorkflowEvent.parseWorkflowEventMessage(id, data, logID);
    }

    public boolean isDone() {
        return WorkflowEventType.DONE.equals(this.event);
    }

    protected WorkflowEvent(WorkflowEventBuilder<?, ?> b) {
        super(b);
        this.id = ((WorkflowEventBuilder)b).id;
        this.event = ((WorkflowEventBuilder)b).event;
        this.message = ((WorkflowEventBuilder)b).message;
        this.interrupt = ((WorkflowEventBuilder)b).interrupt;
        this.error = ((WorkflowEventBuilder)b).error;
    }

    public static WorkflowEventBuilder<?, ?> builder() {
        return new WorkflowEventBuilderImpl();
    }

    public int getId() {
        return this.id;
    }

    public WorkflowEventType getEvent() {
        return this.event;
    }

    public WorkflowEventMessage getMessage() {
        return this.message;
    }

    public WorkflowEventInterrupt getInterrupt() {
        return this.interrupt;
    }

    public WorkflowEventError getError() {
        return this.error;
    }

    @JsonProperty(value="id")
    public void setId(int id) {
        this.id = id;
    }

    @JsonProperty(value="event")
    public void setEvent(WorkflowEventType event) {
        this.event = event;
    }

    @JsonProperty(value="message")
    public void setMessage(WorkflowEventMessage message) {
        this.message = message;
    }

    @JsonProperty(value="interrupt")
    public void setInterrupt(WorkflowEventInterrupt interrupt) {
        this.interrupt = interrupt;
    }

    @JsonProperty(value="error")
    public void setError(WorkflowEventError error) {
        this.error = error;
    }

    public WorkflowEvent() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowEvent)) {
            return false;
        }
        WorkflowEvent other = (WorkflowEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        WorkflowEventType this$event = this.getEvent();
        WorkflowEventType other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        WorkflowEventMessage this$message = this.getMessage();
        WorkflowEventMessage other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        WorkflowEventInterrupt this$interrupt = this.getInterrupt();
        WorkflowEventInterrupt other$interrupt = other.getInterrupt();
        if (this$interrupt == null ? other$interrupt != null : !((Object)this$interrupt).equals(other$interrupt)) {
            return false;
        }
        WorkflowEventError this$error = this.getError();
        WorkflowEventError other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getId();
        WorkflowEventType $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        WorkflowEventMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        WorkflowEventInterrupt $interrupt = this.getInterrupt();
        result = result * 59 + ($interrupt == null ? 43 : ((Object)$interrupt).hashCode());
        WorkflowEventError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WorkflowEvent(super=" + super.toString() + ", id=" + this.getId() + ", event=" + this.getEvent() + ", message=" + this.getMessage() + ", interrupt=" + this.getInterrupt() + ", error=" + this.getError() + ")";
    }

    private static final class WorkflowEventBuilderImpl
    extends WorkflowEventBuilder<WorkflowEvent, WorkflowEventBuilderImpl> {
        private WorkflowEventBuilderImpl() {
        }

        @Override
        protected WorkflowEventBuilderImpl self() {
            return this;
        }

        @Override
        public WorkflowEvent build() {
            return new WorkflowEvent(this);
        }
    }

    public static abstract class WorkflowEventBuilder<C extends WorkflowEvent, B extends WorkflowEventBuilder<C, B>>
    extends BaseResp.BaseRespBuilder<C, B> {
        private int id;
        private WorkflowEventType event;
        private WorkflowEventMessage message;
        private WorkflowEventInterrupt interrupt;
        private WorkflowEventError error;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="id")
        public B id(int id) {
            this.id = id;
            return (B)this.self();
        }

        @JsonProperty(value="event")
        public B event(WorkflowEventType event) {
            this.event = event;
            return (B)this.self();
        }

        @JsonProperty(value="message")
        public B message(WorkflowEventMessage message) {
            this.message = message;
            return (B)this.self();
        }

        @JsonProperty(value="interrupt")
        public B interrupt(WorkflowEventInterrupt interrupt) {
            this.interrupt = interrupt;
            return (B)this.self();
        }

        @JsonProperty(value="error")
        public B error(WorkflowEventError error) {
            this.error = error;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "WorkflowEvent.WorkflowEventBuilder(super=" + super.toString() + ", id=" + this.id + ", event=" + this.event + ", message=" + this.message + ", interrupt=" + this.interrupt + ", error=" + this.error + ")";
        }
    }
}

