/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.conversation;

import com.coze.openapi.api.ConversationMessageAPI;
import com.coze.openapi.client.common.BaseResp;
import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResp;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.client.common.pagination.TokenBasedPaginator;
import com.coze.openapi.client.connversations.message.CreateMessageReq;
import com.coze.openapi.client.connversations.message.CreateMessageResp;
import com.coze.openapi.client.connversations.message.DeleteMessageReq;
import com.coze.openapi.client.connversations.message.DeleteMessageResp;
import com.coze.openapi.client.connversations.message.ListMessageReq;
import com.coze.openapi.client.connversations.message.ListMessageResp;
import com.coze.openapi.client.connversations.message.RetrieveMessageReq;
import com.coze.openapi.client.connversations.message.RetrieveMessageResp;
import com.coze.openapi.client.connversations.message.UpdateMessageReq;
import com.coze.openapi.client.connversations.message.UpdateMessageResp;
import com.coze.openapi.client.connversations.message.model.Message;
import com.coze.openapi.service.utils.Utils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MessageService {
    private final ConversationMessageAPI api;

    public MessageService(ConversationMessageAPI api) {
        this.api = api;
    }

    public CreateMessageResp create(String conversationID, CreateMessageReq req) {
        if (conversationID == null) {
            throw new IllegalArgumentException("conversationID is required");
        }
        BaseResponse<Message> resp = Utils.execute(this.api.create(conversationID, req, req));
        return ((CreateMessageResp.CreateMessageRespBuilder)((BaseResp.BaseRespBuilder)CreateMessageResp.builder().message(resp.getData())).logID(resp.getLogID())).build();
    }

    public CreateMessageResp create(CreateMessageReq req) {
        if (req == null || req.getConversationID() == null) {
            throw new IllegalArgumentException("conversationID is required");
        }
        return this.create(req.getConversationID(), req);
    }

    public PageResp<Message> list(@NotNull ListMessageReq req) {
        if (req == null || req.getConversationID() == null) {
            throw new IllegalArgumentException("conversationID is required");
        }
        String conversationID = req.getConversationID();
        Integer pageSize = req.getLimit();
        PageFetcher pageFetcher = request -> {
            req.setAfterID(request.getPageToken());
            ListMessageResp resp = Utils.execute(this.api.list(conversationID, req, req));
            return PageResponse.builder().hasMore(((List)resp.getData()).size() >= pageSize).data((List)resp.getData()).lastID(resp.getLastID()).nextID(resp.getFirstID()).build();
        };
        TokenBasedPaginator paginator = new TokenBasedPaginator(pageFetcher, req.getLimit());
        PageRequest initialRequest = PageRequest.builder().pageSize(pageSize).pageToken(req.getBeforeID()).build();
        PageResponse currentPage = pageFetcher.fetch(initialRequest);
        return PageResp.builder().items(currentPage.getData()).iterator(paginator).lastID(currentPage.getNextID()).build();
    }

    public RetrieveMessageResp retrieve(RetrieveMessageReq req) {
        if (req == null || req.getConversationID() == null || req.getMessageID() == null) {
            throw new IllegalArgumentException("conversationID and messageID are required");
        }
        BaseResponse<Message> resp = Utils.execute(this.api.retrieve(req.getConversationID(), req.getMessageID(), req));
        return ((RetrieveMessageResp.RetrieveMessageRespBuilder)((BaseResp.BaseRespBuilder)RetrieveMessageResp.builder().message(resp.getData())).logID(resp.getLogID())).build();
    }

    public UpdateMessageResp update(UpdateMessageReq req) {
        if (req == null || req.getConversationID() == null || req.getMessageID() == null) {
            throw new IllegalArgumentException("conversationID and messageID are required");
        }
        return Utils.execute(this.api.update(req.getConversationID(), req.getMessageID(), req, req));
    }

    public DeleteMessageResp delete(DeleteMessageReq req) {
        if (req == null || req.getConversationID() == null || req.getMessageID() == null) {
            throw new IllegalArgumentException("conversationID and messageID are required");
        }
        BaseResponse<Message> resp = Utils.execute(this.api.delete(req.getConversationID(), req.getMessageID(), req));
        return ((DeleteMessageResp.DeleteMessageRespBuilder)((BaseResp.BaseRespBuilder)DeleteMessageResp.builder().message(resp.getData())).logID(resp.getLogID())).build();
    }
}

