/*
 * Decompiled with CFR 0.152.
 */
package com.cuisongliu.druid.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.cuisongliu.druid.autoconfigure.DruidFilterAutoConfiguration;
import com.cuisongliu.druid.autoconfigure.DruidServletAutoConfiguration;
import com.cuisongliu.druid.autoconfigure.properties.DruidProperties;
import com.cuisongliu.druid.autoconfigure.stat.DruidStatAutoConfiguration;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={DruidProperties.class})
@ConditionalOnClass(value={DruidDataSource.class})
@Import(value={DruidServletAutoConfiguration.class, DruidFilterAutoConfiguration.class, DruidStatAutoConfiguration.class})
public class DruidAutoConfiguration {
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid")
    public DataSource dataSource(DruidProperties properties) {
        DruidDataSource datasource = (DruidDataSource)DataSourceBuilder.create().type(DruidDataSource.class).build();
        this.configDruid(datasource, properties);
        return datasource;
    }

    private void configDruid(DruidDataSource dataSource, DruidProperties properties) {
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.username);
        dataSource.setPassword(this.password);
        if (properties.getInitialSize() > 0) {
            dataSource.setInitialSize(properties.getInitialSize());
        }
        if (properties.getMinIdle() > 0) {
            dataSource.setMinIdle(properties.getMinIdle());
        }
        if (properties.getMaxActive() > 0) {
            dataSource.setMaxActive(properties.getMaxActive());
        }
        if (properties.getMaxWait() > 0) {
            dataSource.setMaxWait((long)properties.getMaxWait());
        }
        if (properties.getTimeBetweenEvictionRunsMillis() > 0L) {
            dataSource.setTimeBetweenEvictionRunsMillis(properties.getTimeBetweenEvictionRunsMillis().longValue());
        }
        if (properties.getMaxPoolPreparedStatementPerConnectionSize() > 0) {
            dataSource.setMaxPoolPreparedStatementPerConnectionSize(properties.getMaxPoolPreparedStatementPerConnectionSize().intValue());
        }
        if (properties.getValidationQueryTimeout() > 0) {
            dataSource.setValidationQueryTimeout(properties.getValidationQueryTimeout().intValue());
        }
        if (properties.getMinEvictableIdleTimeMillis() > 0L) {
            dataSource.setMinEvictableIdleTimeMillis(properties.getMinEvictableIdleTimeMillis().longValue());
        }
        dataSource.setValidationQuery(properties.getValidationQuery());
        dataSource.setTestOnReturn(properties.getTestOnReturn().booleanValue());
        dataSource.setTestOnBorrow(properties.isTestOnBorrow());
        dataSource.setTestWhileIdle(properties.getTestWhileIdle().booleanValue());
        dataSource.setPoolPreparedStatements(properties.getPoolPreparedStatements().booleanValue());
        dataSource.setConnectProperties(properties.getConnectionProperties());
        try {
            dataSource.setFilters(properties.getFilters());
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("please check your spring.datasource.druid.filters property.", e);
        }
    }
}

