/*
 * Decompiled with CFR 0.152.
 */
package com.cuisongliu.druid.autoconfigure;

import com.alibaba.druid.support.http.WebStatFilter;
import com.cuisongliu.druid.autoconfigure.properties.DruidFilterProperties;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={DruidFilterProperties.class})
@ConditionalOnProperty(name={"spring.datasource.druid.filter.enable"}, havingValue="true")
public class DruidFilterAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.filter")
    public FilterRegistrationBean druidFilter(DruidFilterProperties properties) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        WebStatFilter filter = new WebStatFilter();
        registration.setFilter((Filter)filter);
        registration.addUrlPatterns(new String[]{properties.getUrlPattern()});
        registration.addInitParameter("exclusions", properties.getExclusions());
        registration.addInitParameter("sessionStatMaxCount", properties.getSessionStatMaxCount().toString());
        registration.addInitParameter("sessionStatEnable", properties.getSessionStatEnable().toString());
        registration.addInitParameter("principalSessionName", properties.getPrincipalSessionName());
        registration.addInitParameter("principalCookieName", properties.getPrincipalCookieName());
        registration.addInitParameter("profileEnable", properties.getProfileEnable().toString());
        return registration;
    }
}

