/*
 * Decompiled with CFR 0.152.
 */
package com.cuisongliu.druid.autoconfigure;

import com.alibaba.druid.support.http.StatViewServlet;
import com.cuisongliu.druid.autoconfigure.properties.DruidServletProperties;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={DruidServletProperties.class})
@ConditionalOnProperty(name={"spring.datasource.druid.servlet.enable"}, havingValue="true", matchIfMissing=true)
public class DruidServletAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.servlet")
    public ServletRegistrationBean druidServlet(DruidServletProperties properties) {
        ServletRegistrationBean reg = new ServletRegistrationBean();
        reg.setServlet((Servlet)new StatViewServlet());
        reg.addUrlMappings(new String[]{properties.getUrlMappings()});
        if (properties.getAllow() != null) {
            reg.addInitParameter("allow", properties.getAllow());
        }
        if (properties.getDeny() != null) {
            reg.addInitParameter("deny", properties.getDeny());
        }
        if (properties.getLoginUsername() != null) {
            reg.addInitParameter("loginUsername", properties.getLoginUsername());
        }
        if (properties.getLoginPassword() != null) {
            reg.addInitParameter("loginPassword", properties.getLoginPassword());
        }
        if (properties.getResetEnable() != null) {
            reg.addInitParameter("resetEnable", properties.getResetEnable().toString());
        }
        return reg;
    }
}

