/*
 * Decompiled with CFR 0.152.
 */
package com.cuisongliu.druid.autoconfigure.condition;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.util.StringUtils;

class ConditionUtil {
    private static ConditionUtil instance = new ConditionUtil();

    static ConditionUtil getInstance() {
        if (instance == null) {
            instance = new ConditionUtil();
        }
        return instance;
    }

    private ConditionUtil() {
    }

    List getAopTypesValue(ConditionContext context) {
        String aopTypesKey = "spring.datasource.druid.stat.aop-types";
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (int i = 0; i < 3; ++i) {
            String field = (String)context.getEnvironment().getProperty(aopTypesKey + "[" + i + "]", String.class);
            if (StringUtils.isEmpty((Object)field)) continue;
            keySet.add(field.toLowerCase());
        }
        if (keySet.size() > 0) {
            return new ArrayList(keySet);
        }
        return new ArrayList();
    }
}

