/*
 * Decompiled with CFR 0.152.
 */
package com.cuisongliu.druid.autoconfigure.stat;

import com.cuisongliu.druid.autoconfigure.condition.NameAopTypesCondition;
import com.cuisongliu.druid.autoconfigure.stat.DruidStatInitAutoConfiguration;
import com.cuisongliu.druid.autoconfigure.stat.DruidStatProperties;
import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@Conditional(value={NameAopTypesCondition.class})
public class DruidNameAopAutoConfiguration
extends DruidStatInitAutoConfiguration {
    @Value(value="${spring.aop.proxy-target-class:false}")
    private boolean proxyTargetClass;

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.stat")
    public BeanNameAutoProxyCreator nameProxyCreator(DruidStatProperties properties) {
        if (properties.getBeanNames() == null) {
            throw new IllegalStateException("spring.datasource.druid.stat.bean-names must  not null.");
        }
        BeanNameAutoProxyCreator creator = new BeanNameAutoProxyCreator();
        creator.setProxyTargetClass(this.proxyTargetClass);
        String[] beanNames = new String[properties.getBeanNames().size()];
        beanNames = properties.getBeanNames().toArray(beanNames);
        creator.setBeanNames(beanNames);
        creator.setInterceptorNames(new String[]{"druid-stat-interceptor"});
        return creator;
    }
}

