/*
 * Decompiled with CFR 0.152.
 */
package com.cuisongliu.druid.autoconfigure.stat;

import com.cuisongliu.druid.autoconfigure.condition.PointcutAopTypesCondition;
import com.cuisongliu.druid.autoconfigure.stat.DruidStatInitAutoConfiguration;
import com.cuisongliu.druid.autoconfigure.stat.DruidStatProperties;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@Conditional(value={PointcutAopTypesCondition.class})
public class DruidPointcutAopAutoConfiguration
extends DruidStatInitAutoConfiguration {
    @Value(value="${spring.aop.proxy-target-class:false}")
    private boolean proxyTargetClass;

    @Bean
    public Pointcut pointcut(DruidStatProperties properties) {
        if (properties.getPatterns().length <= 0) {
            throw new IllegalStateException("spring.datasource.druid.stat.target-bean-type must  not null.");
        }
        JdkRegexpMethodPointcut pointcut = new JdkRegexpMethodPointcut();
        pointcut.setPatterns(properties.getPatterns());
        return pointcut;
    }

    @Bean
    public Advisor advisor(DruidStatProperties properties) {
        return new DefaultPointcutAdvisor(this.pointcut(properties), (Advice)this.druidStatInterceptor());
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.stat")
    public DefaultAdvisorAutoProxyCreator regexpProxyCreator(DruidStatProperties properties) {
        DefaultAdvisorAutoProxyCreator creator = new DefaultAdvisorAutoProxyCreator();
        creator.setProxyTargetClass(this.proxyTargetClass);
        return creator;
    }
}

