/*
 * Decompiled with CFR 0.152.
 */
package com.cuisongliu.druid.autoconfigure.stat;

import com.alibaba.druid.support.spring.stat.BeanTypeAutoProxyCreator;
import com.cuisongliu.druid.autoconfigure.condition.TypeAopTypesCondition;
import com.cuisongliu.druid.autoconfigure.stat.DruidStatInitAutoConfiguration;
import com.cuisongliu.druid.autoconfigure.stat.DruidStatProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@Conditional(value={TypeAopTypesCondition.class})
public class DruidTypeAopAutoConfiguration
extends DruidStatInitAutoConfiguration {
    @Value(value="${spring.aop.proxy-target-class:false}")
    private boolean proxyTargetClass;

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.stat")
    public BeanTypeAutoProxyCreator typeProxyCreator(DruidStatProperties properties) {
        if (properties.getTargetBeanType() == null) {
            throw new IllegalStateException("spring.datasource.druid.stat.target-bean-type must  not null.");
        }
        BeanTypeAutoProxyCreator creator = new BeanTypeAutoProxyCreator();
        creator.setTargetBeanType(properties.getTargetBeanType());
        creator.setProxyTargetClass(this.proxyTargetClass);
        creator.setInterceptorNames(new String[]{"druid-stat-interceptor"});
        return creator;
    }
}

