/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.constants;

import com.dangdang.ddframe.rdb.sharding.exception.DatabaseTypeUnsupportedException;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Arrays;

public enum DatabaseType {
    H2("H2"),
    MySQL("MySQL"),
    Oracle("Oracle"),
    SQLServer("Microsoft SQL Server"),
    DB2("DB2"),
    PostgreSQL("PostgreSQL");

    private final String productName;

    private DatabaseType(String productName) {
        this.productName = productName;
    }

    public static DatabaseType valueFrom(final String databaseProductName) {
        Optional databaseTypeOptional = Iterators.tryFind(Arrays.asList(DatabaseType.values()).iterator(), (Predicate)new Predicate<DatabaseType>(){

            public boolean apply(DatabaseType input) {
                return input.productName.equals(databaseProductName);
            }
        });
        if (databaseTypeOptional.isPresent()) {
            return (DatabaseType)((Object)databaseTypeOptional.get());
        }
        throw new DatabaseTypeUnsupportedException(databaseProductName);
    }
}

