/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.adapter;

import com.dangdang.ddframe.rdb.sharding.jdbc.unsupported.AbstractUnsupportedOperationStatement;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;

public abstract class AbstractStatementAdapter
extends AbstractUnsupportedOperationStatement {
    private final Class<? extends Statement> recordTargetClass;
    private boolean closed;
    private boolean poolable;
    private int fetchSize;

    protected abstract void clearRouteStatements();

    @Override
    public final void close() throws SQLException {
        for (Statement statement : this.getRoutedStatements()) {
            statement.close();
        }
        this.closed = true;
        this.clearRouteStatements();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        this.poolable = poolable;
        if (this.getRoutedStatements().isEmpty()) {
            this.recordMethodInvocation(this.recordTargetClass, "setPoolable", new Class[]{Boolean.TYPE}, new Object[]{poolable});
            return;
        }
        for (Statement statement : this.getRoutedStatements()) {
            statement.setPoolable(poolable);
        }
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
        if (this.getRoutedStatements().isEmpty()) {
            this.recordMethodInvocation(this.recordTargetClass, "setFetchSize", new Class[]{Integer.TYPE}, new Object[]{rows});
            return;
        }
        for (Statement statement : this.getRoutedStatements()) {
            statement.setFetchSize(rows);
        }
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.getRoutedStatements().isEmpty()) {
            this.recordMethodInvocation(this.recordTargetClass, "setEscapeProcessing", new Class[]{Boolean.TYPE}, new Object[]{enable});
            return;
        }
        for (Statement statement : this.getRoutedStatements()) {
            statement.setEscapeProcessing(enable);
        }
    }

    @Override
    public final void cancel() throws SQLException {
        for (Statement statement : this.getRoutedStatements()) {
            statement.cancel();
        }
    }

    @Override
    public final void setCursorName(String name) throws SQLException {
        if (this.getRoutedStatements().isEmpty()) {
            this.recordMethodInvocation(this.recordTargetClass, "setCursorName", new Class[]{String.class}, new Object[]{name});
            return;
        }
        for (Statement statement : this.getRoutedStatements()) {
            statement.setCursorName(name);
        }
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        long result = 0L;
        boolean hasResult = false;
        for (Statement statement : this.getRoutedStatements()) {
            if (statement.getUpdateCount() > -1) {
                hasResult = true;
            }
            result += (long)statement.getUpdateCount();
        }
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        return hasResult ? Long.valueOf(result).intValue() : -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getMaxFieldSize();
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLException {
        if (this.getRoutedStatements().isEmpty()) {
            this.recordMethodInvocation(this.recordTargetClass, "setMaxFieldSize", new Class[]{Integer.TYPE}, new Object[]{max});
            return;
        }
        for (Statement statement : this.getRoutedStatements()) {
            statement.setMaxFieldSize(max);
        }
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? -1 : this.getRoutedStatements().iterator().next().getMaxRows();
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        if (this.getRoutedStatements().isEmpty()) {
            this.recordMethodInvocation(this.recordTargetClass, "setMaxRows", new Class[]{Integer.TYPE}, new Object[]{max});
            return;
        }
        for (Statement statement : this.getRoutedStatements()) {
            statement.setMaxRows(max);
        }
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        if (this.getRoutedStatements().isEmpty()) {
            this.recordMethodInvocation(this.recordTargetClass, "setQueryTimeout", new Class[]{Integer.TYPE}, new Object[]{seconds});
            return;
        }
        for (Statement statement : this.getRoutedStatements()) {
            statement.setQueryTimeout(seconds);
        }
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        if (1 == this.getRoutedStatements().size()) {
            return this.getRoutedStatements().iterator().next().getGeneratedKeys();
        }
        throw new IllegalStateException("Cannot call getGeneratedKeys if sharding statements more than 1.");
    }

    protected abstract Collection<? extends Statement> getRoutedStatements();

    @ConstructorProperties(value={"recordTargetClass"})
    public AbstractStatementAdapter(Class<? extends Statement> recordTargetClass) {
        this.recordTargetClass = recordTargetClass;
    }
}

