/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.util;

import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.jdbc.util.JdbcMethodInvocation;
import java.beans.ConstructorProperties;
import java.util.AbstractList;
import java.util.ArrayList;

public class ParameterList
extends AbstractList<Object> {
    private final ArrayList<JdbcMethodInvocation> jdbcMethodInvocations = new ArrayList();
    private final Class<?> targetClass;

    public final void recordMethodInvocation(int index, String methodName, Class<?>[] argumentTypes, Object[] arguments) {
        this.jdbcMethodInvocations.ensureCapacity(index);
        int max = this.jdbcMethodInvocations.size();
        while (max++ <= index - 1) {
            this.jdbcMethodInvocations.add(null);
        }
        try {
            this.jdbcMethodInvocations.set(index - 1, new JdbcMethodInvocation(this.targetClass.getMethod(methodName, argumentTypes), arguments));
        }
        catch (NoSuchMethodException ex) {
            throw new ShardingJdbcException(ex);
        }
    }

    public final void replayMethodsInvocation(Object target) {
        for (JdbcMethodInvocation each : this.jdbcMethodInvocations) {
            each.invoke(target);
        }
    }

    @Override
    public Object set(int index, Object element) {
        Object origin = this.jdbcMethodInvocations.get(index).getArguments()[1];
        this.jdbcMethodInvocations.get((int)index).getArguments()[1] = element;
        return origin;
    }

    @Override
    public Object get(int index) {
        JdbcMethodInvocation invocation = this.jdbcMethodInvocations.get(index);
        if (null == invocation) {
            return null;
        }
        if ("setNull".equals(invocation.getMethod().getName())) {
            return null;
        }
        return this.jdbcMethodInvocations.get(index).getArguments()[1];
    }

    @Override
    public int size() {
        return this.jdbcMethodInvocations.size();
    }

    @Override
    public void clear() {
        this.jdbcMethodInvocations.clear();
    }

    @ConstructorProperties(value={"targetClass"})
    public ParameterList(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public ArrayList<JdbcMethodInvocation> getJdbcMethodInvocations() {
        return this.jdbcMethodInvocations;
    }
}

