/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.resultset.memory;

import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.AbstractUnsupportedOperationMemoryResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.ResultSetRow;
import com.dangdang.ddframe.rdb.sharding.merger.util.ResultSetUtil;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMemoryResultSet
extends AbstractUnsupportedOperationMemoryResultSet {
    private static final Logger log = LoggerFactory.getLogger(AbstractMemoryResultSet.class);
    private boolean beforeFirst = true;
    private ResultSetRow currentRow;
    private boolean wasNull;

    public AbstractMemoryResultSet(List<ResultSet> resultSets) throws SQLException {
        super(resultSets);
        LoggerFactory.getLogger((String)this.getClass().getName()).debug("{} join pipeline", (Object)this.hashCode());
    }

    @Override
    public boolean next() throws SQLException {
        Optional<? extends ResultSetRow> row;
        if (this.beforeFirst) {
            this.initRows(this.getResultSets());
            this.beforeFirst = false;
        }
        if ((row = this.nextRow()).isPresent()) {
            this.currentRow = (ResultSetRow)row.get();
            log.trace("Current row is {}", (Object)this.currentRow);
            return true;
        }
        return false;
    }

    protected abstract void initRows(List<ResultSet> var1) throws SQLException;

    protected abstract Optional<? extends ResultSetRow> nextRow() throws SQLException;

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        String formattedColumnLabel;
        String string = formattedColumnLabel = this.getColumnLabelIndexMap().containsKey(columnLabel) ? columnLabel : SQLUtil.getExactlyValue(columnLabel);
        if (!this.getColumnLabelIndexMap().containsKey(formattedColumnLabel)) {
            throw new SQLException(String.format("Column label %s does not exist", formattedColumnLabel));
        }
        return this.getColumnLabelIndexMap().get(formattedColumnLabel);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"Result set is closed");
        Preconditions.checkState((!this.beforeFirst ? 1 : 0) != 0, (Object)"Before start of result set");
        Preconditions.checkState((null != this.currentRow ? 1 : 0) != 0, (Object)"After end of result set");
        Preconditions.checkArgument((boolean)this.currentRow.inRange(columnIndex), (Object)String.format("Column Index %d out of range", columnIndex));
        Object result = this.currentRow.getCell(columnIndex);
        if (null == result) {
            this.wasNull = true;
        }
        return result;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)ResultSetUtil.convertValue(this.getObject(columnIndex), String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object cell = this.getObject(columnIndex);
        if (null == cell) {
            this.wasNull = true;
            return false;
        }
        return cell instanceof Boolean ? (Boolean)cell : Boolean.valueOf(cell.toString());
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)ResultSetUtil.convertValue(this.getObject(columnIndex), Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (Short)ResultSetUtil.convertValue(this.getObject(columnIndex), Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (Integer)ResultSetUtil.convertValue(this.getObject(columnIndex), Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return (Long)ResultSetUtil.convertValue(this.getObject(columnIndex), Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)ResultSetUtil.convertValue(this.getObject(columnIndex), Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return (Double)ResultSetUtil.convertValue(this.getObject(columnIndex), Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal result = (BigDecimal)ResultSetUtil.convertValue(this.getObject(columnIndex), BigDecimal.class);
        return result.setScale(scale, 4);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.getObject(columnIndex), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (null == value) {
            this.wasNull = true;
            return null;
        }
        return value.getBytes();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.getObject(columnIndex), Date.class);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.getObject(columnIndex), Time.class);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.getObject(columnIndex), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (null == value) {
            this.wasNull = true;
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException ex) {
            throw new SQLException("URL Malformed URL exception");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.getResultSets().get(0).getStatement();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSets().get(0).getMetaData();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        int result = 0;
        for (ResultSet each : this.getResultSets()) {
            result += each.getFetchSize();
        }
        return result;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    protected ResultSetRow getCurrentRow() {
        return this.currentRow;
    }
}

