/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser;

import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.dangdang.ddframe.rdb.sharding.constants.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.exception.DatabaseTypeUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql.MySQLDeleteVisitor;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql.MySQLInsertVisitor;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql.MySQLSelectVisitor;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql.MySQLUpdateVisitor;
import java.util.HashMap;
import java.util.Map;

public final class SQLVisitorRegistry {
    private static final Map<DatabaseType, Class<? extends SQLASTOutputVisitor>> SELECT_REGISTRY = new HashMap<DatabaseType, Class<? extends SQLASTOutputVisitor>>(DatabaseType.values().length);
    private static final Map<DatabaseType, Class<? extends SQLASTOutputVisitor>> INSERT_REGISTRY = new HashMap<DatabaseType, Class<? extends SQLASTOutputVisitor>>(DatabaseType.values().length);
    private static final Map<DatabaseType, Class<? extends SQLASTOutputVisitor>> UPDATE_REGISTRY = new HashMap<DatabaseType, Class<? extends SQLASTOutputVisitor>>(DatabaseType.values().length);
    private static final Map<DatabaseType, Class<? extends SQLASTOutputVisitor>> DELETE_REGISTRY = new HashMap<DatabaseType, Class<? extends SQLASTOutputVisitor>>(DatabaseType.values().length);

    private static void registerSelectVistor() {
        SELECT_REGISTRY.put(DatabaseType.H2, MySQLSelectVisitor.class);
        SELECT_REGISTRY.put(DatabaseType.MySQL, MySQLSelectVisitor.class);
        SELECT_REGISTRY.put(DatabaseType.Oracle, MySQLSelectVisitor.class);
        SELECT_REGISTRY.put(DatabaseType.SQLServer, MySQLSelectVisitor.class);
        SELECT_REGISTRY.put(DatabaseType.DB2, MySQLSelectVisitor.class);
        SELECT_REGISTRY.put(DatabaseType.PostgreSQL, MySQLSelectVisitor.class);
    }

    private static void registerInsertVistor() {
        INSERT_REGISTRY.put(DatabaseType.H2, MySQLInsertVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.MySQL, MySQLInsertVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.Oracle, MySQLInsertVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.SQLServer, MySQLInsertVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.DB2, MySQLInsertVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.PostgreSQL, MySQLInsertVisitor.class);
    }

    private static void registerUpdateVistor() {
        UPDATE_REGISTRY.put(DatabaseType.H2, MySQLUpdateVisitor.class);
        UPDATE_REGISTRY.put(DatabaseType.MySQL, MySQLUpdateVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.Oracle, MySQLUpdateVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.SQLServer, MySQLUpdateVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.DB2, MySQLUpdateVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.PostgreSQL, MySQLUpdateVisitor.class);
    }

    private static void registerDeleteVistor() {
        DELETE_REGISTRY.put(DatabaseType.H2, MySQLDeleteVisitor.class);
        DELETE_REGISTRY.put(DatabaseType.MySQL, MySQLDeleteVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.Oracle, MySQLDeleteVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.SQLServer, MySQLDeleteVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.DB2, MySQLDeleteVisitor.class);
        INSERT_REGISTRY.put(DatabaseType.PostgreSQL, MySQLDeleteVisitor.class);
    }

    public static Class<? extends SQLASTOutputVisitor> getSelectVistor(DatabaseType databaseType) {
        return SQLVisitorRegistry.getVistor(databaseType, SELECT_REGISTRY);
    }

    public static Class<? extends SQLASTOutputVisitor> getInsertVistor(DatabaseType databaseType) {
        return SQLVisitorRegistry.getVistor(databaseType, INSERT_REGISTRY);
    }

    public static Class<? extends SQLASTOutputVisitor> getUpdateVistor(DatabaseType databaseType) {
        return SQLVisitorRegistry.getVistor(databaseType, UPDATE_REGISTRY);
    }

    public static Class<? extends SQLASTOutputVisitor> getDeleteVistor(DatabaseType databaseType) {
        return SQLVisitorRegistry.getVistor(databaseType, DELETE_REGISTRY);
    }

    private static Class<? extends SQLASTOutputVisitor> getVistor(DatabaseType databaseType, Map<DatabaseType, Class<? extends SQLASTOutputVisitor>> registry) {
        if (!registry.containsKey((Object)databaseType)) {
            throw new DatabaseTypeUnsupportedException(databaseType.name());
        }
        return registry.get((Object)databaseType);
    }

    private SQLVisitorRegistry() {
    }

    static {
        SQLVisitorRegistry.registerSelectVistor();
        SQLVisitorRegistry.registerInsertVistor();
        SQLVisitorRegistry.registerUpdateVistor();
        SQLVisitorRegistry.registerDeleteVistor();
    }
}

