/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.single;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Condition;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.List;

public class SingleRouterUtil {
    public static ShardingValue<?> convertConditionToShardingValue(Condition condition) {
        List<Comparable<?>> conditionValues = condition.getValues();
        switch (condition.getOperator()) {
            case EQUAL: 
            case IN: {
                if (1 == conditionValues.size()) {
                    return new ShardingValue(condition.getColumn().getTableName(), condition.getColumn().getColumnName(), conditionValues.get(0));
                }
                return new ShardingValue(condition.getColumn().getTableName(), condition.getColumn().getColumnName(), conditionValues);
            }
            case BETWEEN: {
                return new ShardingValue(condition.getColumn().getTableName(), condition.getColumn().getColumnName(), Range.range(conditionValues.get(0), (BoundType)BoundType.CLOSED, conditionValues.get(1), (BoundType)BoundType.CLOSED));
            }
        }
        throw new UnsupportedOperationException(condition.getOperator().getExpression());
    }

    private SingleRouterUtil() {
    }
}

