/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor.wrapper;

import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;

public abstract class AbstractExecutorWrapper {
    private final SQLExecutionUnit sqlExecutionUnit;

    final boolean isDML() {
        String sql = this.sqlExecutionUnit.getSql();
        return sql.toLowerCase().startsWith("insert") || sql.toLowerCase().startsWith("update") || sql.toLowerCase().startsWith("delete");
    }

    final boolean isDQL() {
        return this.sqlExecutionUnit.getSql().toLowerCase().startsWith("select");
    }

    public abstract Optional<DMLExecutionEvent> getDMLExecutionEvent();

    public abstract Optional<DQLExecutionEvent> getDQLExecutionEvent();

    @ConstructorProperties(value={"sqlExecutionUnit"})
    public AbstractExecutorWrapper(SQLExecutionUnit sqlExecutionUnit) {
        this.sqlExecutionUnit = sqlExecutionUnit;
    }

    public SQLExecutionUnit getSqlExecutionUnit() {
        return this.sqlExecutionUnit;
    }
}

