/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.bean;

import com.dexcoder.commons.bean.BeanConverterConfig;
import com.dexcoder.commons.bean.EnumStringConverter;
import com.dexcoder.commons.bean.IntrospectionCache;
import com.dexcoder.commons.bean.TypeConverter;
import com.dexcoder.commons.enums.IEnum;
import com.dexcoder.commons.exceptions.CommonsAssistantException;
import com.dexcoder.commons.utils.ClassUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanConverter {
    public static <T> List<T> mapToBean(List<Map<String, Object>> mapList, Class<T> beanClass) {
        ArrayList<T> beanList = new ArrayList<T>(mapList.size());
        if (mapList == null) {
            return beanList;
        }
        for (Map<String, Object> map : mapList) {
            T t = BeanConverter.mapToBean(map, beanClass);
            beanList.add(t);
        }
        return beanList;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        Object bean = ClassUtils.newInstance(beanClass);
        if (map == null) {
            return (T)bean;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            PropertyDescriptor targetPd = BeanConverter.getPropertyDescriptor(beanClass, entry.getKey());
            Method writeMethod = targetPd.getWriteMethod();
            ClassUtils.invokeMethod(writeMethod, bean, entry.getValue());
        }
        return (T)bean;
    }

    public static <T> List<T> convert(Class<T> clazz, List<?> list) {
        return BeanConverter.convert(clazz, list, null);
    }

    public static <T> List<T> convert(Class<T> clazz, List<?> list, String[] ignoreProperties) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (list == null || list.isEmpty()) {
            return resultList;
        }
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                T t = clazz.newInstance();
                Object obj = iterator.next();
                t = BeanConverter.convert(t, obj, ignoreProperties);
                resultList.add(t);
            }
            catch (Exception e) {
                throw new CommonsAssistantException("\u5217\u8868\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
        }
        return resultList;
    }

    public static <T> T convert(T target, Object source) {
        return BeanConverter.convert(target, source, null);
    }

    public static <T> T convert(T target, Object source, String[] ignoreProperties) {
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        BeanConverter.copySameProperties(target, source, ignoreList);
        return target;
    }

    private static void copySameProperties(Object target, Object source, List<String> ignoreList) {
        PropertyDescriptor[] targetPds;
        for (PropertyDescriptor targetPd : targetPds = BeanConverter.getPropertyDescriptors(target.getClass())) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanConverter.getPropertyDescriptor(source.getClass(), targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            Method readMethod = sourcePd.getReadMethod();
            Object value = ClassUtils.invokeMethod(readMethod, source);
            Method writeMethod = targetPd.getWriteMethod();
            value = BeanConverter.typeConvert(sourcePd.getPropertyType(), targetPd.getPropertyType(), value);
            ClassUtils.invokeMethod(writeMethod, target, value);
        }
    }

    private static Object typeConvert(Class<?> sourcePropertyType, Class<?> targetPropertyType, Object value) {
        if (value == null) {
            return null;
        }
        Map<String, TypeConverter> converters = BeanConverter.getConverters();
        if (converters == null || converters.isEmpty()) {
            return value;
        }
        TypeConverter typeConverter = converters.get(BeanConverterConfig.getCovertKey(sourcePropertyType, targetPropertyType));
        if (typeConverter != null) {
            return typeConverter.convert(sourcePropertyType, targetPropertyType, value);
        }
        for (TypeConverter converter : converters.values()) {
            if (!converter.getSourceTypeClass().isAssignableFrom(sourcePropertyType) || !converter.getTargetTypeClass().isAssignableFrom(targetPropertyType)) continue;
            return converter.convert(sourcePropertyType, targetPropertyType, value);
        }
        return value;
    }

    public static void registerConverter(TypeConverter converter) {
        BeanConverterConfig.getInstance().registerConverter(converter);
    }

    public static void unregisterConverter(Class<?> sourceClass, Class<?> targetClass) {
        BeanConverterConfig.getInstance().unregisterConverter(sourceClass, targetClass);
    }

    public static void clearConverter() {
        BeanConverterConfig.getInstance().clearConverter();
    }

    public static Map<String, TypeConverter> getConverters() {
        BeanConverter.registerConverter(new EnumStringConverter(IEnum.class, String.class));
        BeanConverter.registerConverter(new EnumStringConverter(String.class, IEnum.class));
        return BeanConverterConfig.getInstance().getConverters();
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        IntrospectionCache introspectionCache = IntrospectionCache.forClass(beanClass);
        return introspectionCache.getPropertyDescriptors();
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) {
        IntrospectionCache introspectionCache = IntrospectionCache.forClass(beanClass);
        return introspectionCache.getPropertyDescriptor(propertyName);
    }
}

