/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.cache;

import com.dexcoder.commons.cache.CacheMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheMap<K, V>
implements CacheMap<K, V> {
    protected Map<K, CacheObject<K, V>> cacheMap;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.cacheLock.readLock();
    private final Lock writeLock = this.cacheLock.writeLock();
    protected int cacheSize;
    protected long defaultExpire;
    protected boolean existCustomExpire;

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    public AbstractCacheMap(int cacheSize, long defaultExpire) {
        this.cacheSize = cacheSize;
        this.defaultExpire = defaultExpire;
    }

    @Override
    public long getDefaultExpire() {
        return this.defaultExpire;
    }

    protected boolean isNeedClearExpiredObject() {
        return this.defaultExpire > 0L || this.existCustomExpire;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.defaultExpire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, long expire) {
        this.writeLock.lock();
        try {
            CacheObject<K, V> co = new CacheObject<K, V>(key, value, expire);
            if (expire != 0L) {
                this.existCustomExpire = true;
            }
            if (this.isFull()) {
                this.eliminate();
            }
            this.cacheMap.put(key, co);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.readLock.lock();
        try {
            CacheObject<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                V v = null;
                return v;
            }
            if (co.isExpired()) {
                this.cacheMap.remove(key);
                V v = null;
                return v;
            }
            V v = co.getObject();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int eliminate() {
        this.writeLock.lock();
        try {
            int n = this.eliminateCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract int eliminateCache();

    @Override
    public boolean isFull() {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.cacheMap.size() >= this.cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        this.writeLock.lock();
        try {
            this.cacheMap.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheObject<K2, V2> {
        final K2 key;
        final V2 cachedObject;
        long lastAccess;
        long accessCount;
        long liveTime;

        CacheObject(K2 key, V2 value, long liveTime) {
            this.key = key;
            this.cachedObject = value;
            this.liveTime = liveTime;
            this.lastAccess = System.currentTimeMillis();
        }

        public boolean isExpired() {
            if (this.liveTime == 0L) {
                return false;
            }
            return this.lastAccess + this.liveTime < System.currentTimeMillis();
        }

        public V2 getObject() {
            ++this.accessCount;
            return this.cachedObject;
        }
    }
}

