/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.mvc;

import com.dexcoder.commons.enums.IEnum;
import com.dexcoder.commons.utils.EnumUtils;
import com.dexcoder.commons.utils.StrUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEnumConverterFactory
implements ConverterFactory<String, Enum> {
    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        if (IEnum.class.isAssignableFrom(targetType)) {
            return new IEnumConverter<T>(targetType);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IEnumConverter<T extends Enum>
    implements Converter<String, T> {
        private final Class<T> enumType;

        public IEnumConverter(Class<T> enumType) {
            this.enumType = enumType;
        }

        public T convert(String source) {
            if (StrUtils.isBlank(source)) {
                return null;
            }
            return (T)((Enum)EnumUtils.getEnum(this.enumType, source));
        }
    }
}

