/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.office;

import com.dexcoder.commons.exceptions.CommonsAssistantException;
import com.dexcoder.commons.office.ExcelCell;
import com.dexcoder.commons.office.ExcelRow;
import com.dexcoder.commons.office.ExcelSheet;
import com.dexcoder.commons.utils.StrUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelReadTools {
    public static List<ExcelSheet> read(File file) {
        byte[] bytes = ExcelReadTools.readFileToByte(file);
        return ExcelReadTools.read(bytes);
    }

    public static List<ExcelSheet> read(byte[] bytes) {
        Workbook workbook = ExcelReadTools.readWorkbook(bytes);
        int numberOfSheets = workbook.getNumberOfSheets();
        ArrayList<ExcelSheet> sheetList = new ArrayList<ExcelSheet>(numberOfSheets);
        for (int i = 0; i < numberOfSheets; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            ExcelSheet excelSheet = ExcelReadTools.readSheet(sheet);
            sheetList.add(excelSheet);
        }
        return sheetList;
    }

    public static ExcelSheet readFirstSheet(File file) {
        byte[] bytes = ExcelReadTools.readFileToByte(file);
        return ExcelReadTools.readFirstSheet(bytes);
    }

    public static ExcelSheet readFirstSheet(byte[] bytes) {
        Workbook workbook = ExcelReadTools.readWorkbook(bytes);
        Sheet sheet = workbook.getSheetAt(0);
        return ExcelReadTools.readSheet(sheet);
    }

    private static ExcelSheet readSheet(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        ExcelSheet excelSheet = new ExcelSheet();
        excelSheet.setSheetName(sheet.getSheetName());
        int rowsCount = sheet.getLastRowNum();
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>(rowsCount);
        for (int i = 0; i <= rowsCount; ++i) {
            Row row = sheet.getRow(i);
            ExcelRow excelRow = ExcelReadTools.readRow(row);
            rows.add(excelRow);
        }
        excelSheet.setRows(rows);
        return excelSheet;
    }

    private static ExcelRow readRow(Row row) {
        ExcelRow excelRow = new ExcelRow();
        if (row == null) {
            return excelRow;
        }
        int cellCount = row.getLastCellNum();
        ArrayList<ExcelCell> excelCells = new ArrayList<ExcelCell>(cellCount);
        for (int i = 0; i < cellCount; ++i) {
            Cell cell = row.getCell(i);
            ExcelCell excelCell = ExcelReadTools.readCell(cell);
            excelCells.add(excelCell);
        }
        excelRow.setCells(excelCells);
        return excelRow;
    }

    private static ExcelCell readCell(Cell cell) {
        Object value;
        ExcelCell excelCell = new ExcelCell();
        if (cell == null) {
            return excelCell;
        }
        int type = cell.getCellType();
        switch (type) {
            case 2: {
                value = cell.getCellFormula();
                break;
            }
            case 4: {
                value = cell.getBooleanCellValue();
                break;
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    value = StrUtils.replace(dateFormat.format(date), " 00:00:00", "");
                    break;
                }
                value = cell.getNumericCellValue();
                DecimalFormat df = new DecimalFormat("0");
                value = df.format(value);
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        excelCell.setValue(value);
        return excelCell;
    }

    private static Workbook readWorkbook(byte[] bytes) {
        Workbook workbook;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(bytes);
            workbook = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            try {
                throw new CommonsAssistantException("\u521d\u59cb\u5316Workbook\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)is);
        return workbook;
    }

    private static byte[] readFileToByte(File file) {
        try {
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            return bytes;
        }
        catch (IOException e) {
            throw new CommonsAssistantException("\u5c06\u6587\u4ef6\u8f6c\u6362\u6210byte\u6570\u7ec4\u5931\u8d25", (Throwable)e);
        }
    }
}

