/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.office;

import com.dexcoder.commons.office.ExcelCell;
import com.dexcoder.commons.utils.StrUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelRow {
    private List<ExcelCell> cells;

    public List<ExcelCell> getCells() {
        return this.cells;
    }

    public void setCells(List<ExcelCell> cells) {
        this.cells = cells;
    }

    public int getTotalCellsNum() {
        return this.cells == null ? 0 : this.cells.size();
    }

    public boolean hasCells() {
        return this.cells != null && !this.cells.isEmpty();
    }

    public boolean isEmptyRow() {
        if (this.cells == null || this.cells.isEmpty()) {
            return true;
        }
        for (ExcelCell excelCell : this.cells) {
            if (excelCell == null || excelCell.getValue() == null || !StrUtils.isNotBlank(excelCell.getStringValue())) continue;
            return false;
        }
        return true;
    }

    public void addCell(Object value) {
        ExcelCell excelCell = new ExcelCell(value);
        this.cells.add(excelCell);
    }

    public ExcelCell getFirstCell() {
        return this.cells == null ? null : this.cells.iterator().next();
    }

    public ExcelCell getCell(int i) {
        return this.cells == null ? null : this.cells.get(i);
    }

    public Object getCellValue(int i) {
        return this.cells == null ? null : this.cells.get(i).getValue();
    }

    public String getCellStringValue(int i) {
        return this.cells == null ? null : this.cells.get(i).getStringValue();
    }

    public String toString() {
        if (this.cells == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ExcelCell excelCell : this.cells) {
            sb.append(excelCell == null ? "null" : excelCell.toString()).append(" ");
        }
        return sb.toString();
    }
}

