/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.result;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunResult {
    protected boolean success = true;
    protected String code;
    protected List<String> errors;
    protected List<String> messages;

    public RunResult() {
    }

    public RunResult(boolean isSuccess) {
        this.success = isSuccess;
    }

    public RunResult(boolean isSuccess, String resultCode) {
        this.success = isSuccess;
        this.code = resultCode;
    }

    public void addMessage(String message) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(message);
    }

    public void addError(String error) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(error);
    }

    public String getStrErrors() {
        if (this.errors == null || this.errors.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String error : this.errors) {
            sb.append(error);
            sb.append(";");
        }
        return sb.toString();
    }

    public String getStrMessages() {
        if (this.messages == null || this.messages.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String resultMessage : this.messages) {
            sb.append(resultMessage);
            sb.append(";");
        }
        return sb.toString();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }
}

