/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.cache.CacheMap;
import com.dexcoder.commons.cache.LRUCache;

public class CacheUtils {
    public static final int DEFAULT_CACHE_SIZE = 5000;
    public static final long DEFAULT_CACHE_LIVE_TIME = 3600000L;
    private static CacheMap<Object, Object> cacheMap = new LRUCache<Object, Object>(5000, 3600000L);

    public static int getCacheSize() {
        return cacheMap.getCacheSize();
    }

    public static int getCurrentCacheSize() {
        return cacheMap.size();
    }

    public static Object get(Object key) {
        return cacheMap.get(key);
    }

    public static String getForString(Object key) {
        return (String)cacheMap.get(key);
    }

    public static Object getChild(Object parentKey, Object key) {
        CacheMap map = (CacheMap)cacheMap.get(key);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static void put(Object key, Object value) {
        CacheUtils.put(key, value, 3600000L);
    }

    public static void put(Object key, Object value, long liveTime) {
        cacheMap.put(key, value, liveTime);
    }

    public static void putChild(Object parentKey, Object key, Object value) {
        CacheUtils.putChild(parentKey, key, value, 3600000L);
    }

    public static void putChild(Object parentKey, Object key, Object value, long liveTime) {
        LRUCache<Object, Object> map = (LRUCache<Object, Object>)cacheMap.get(parentKey);
        if (map == null) {
            map = new LRUCache<Object, Object>(5000, 3600000L);
        }
        map.put(key, value);
        cacheMap.put(parentKey, map, liveTime);
    }

    public static void remove(Object key) {
        cacheMap.remove(key);
    }

    public static void removeChild(Object parentKey, Object key) {
        CacheMap map = (CacheMap)cacheMap.get(parentKey);
        if (map != null) {
            map.remove(key);
        }
    }

    public static void clear() {
        cacheMap.clear();
    }
}

