/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.exceptions.CommonsAssistantException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    public static void zip(String srcFileName, String targetFileName) {
        ZipOutputStream zos = null;
        BufferedOutputStream bos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(targetFileName));
            bos = new BufferedOutputStream(zos);
            File srcFile = new File(srcFileName);
            ZipUtils.zip(zos, srcFile, srcFile.getName(), bos);
        }
        catch (Exception e) {
            try {
                throw new CommonsAssistantException("\u538b\u7f29\u6253\u5305\u6587\u4ef6\u6210zip\u5305\u5931\u8d25:" + srcFileName, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(zos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)zos);
    }

    private static void zip(ZipOutputStream zos, File file, String base, BufferedOutputStream bos) throws Exception {
        if (file.isDirectory()) {
            zos.putNextEntry(new ZipEntry(base + "/"));
            zos.flush();
            File[] fl = file.listFiles();
            for (int i = 0; i < fl.length; ++i) {
                ZipUtils.zip(zos, fl[i], base + "/" + fl[i].getName(), bos);
            }
        } else {
            zos.putNextEntry(new ZipEntry(base));
            bos.write(FileUtils.readFileToByteArray((File)file));
            bos.flush();
        }
    }
}

