/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.interceptor;

import com.dexcoder.commons.exceptions.DexcoderException;
import com.dexcoder.commons.interceptor.RunBinderTransactionAspectSupport;
import com.dexcoder.commons.result.RunBinder;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RunBinderInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RunBinderInterceptor.class);
    private static final long LOG_TIMEOUT = 1000L;

    @Pointcut(value="@within(org.springframework.stereotype.Service)")
    public void serviceAnnotation() {
    }

    @Pointcut(value="bean(*ServiceImpl)")
    public void serviceName() {
    }

    @Around(value="serviceAnnotation() || serviceName()")
    public Object around(ProceedingJoinPoint pjp) {
        if (RunBinderTransactionAspectSupport.isRollbackOnly()) {
            return null;
        }
        String targetClass = pjp.getTarget().getClass().getName();
        String targetMethod = pjp.getSignature().getName();
        long beginTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("start:[class={},method={},beginTime={}]", new Object[]{targetClass, targetMethod, beginTime});
        }
        Object result = null;
        try {
            result = pjp.proceed();
        }
        catch (DexcoderException dexcoderException) {
            RunBinderTransactionAspectSupport.setRollbackOnly();
            RunBinder.addError(dexcoderException);
            LOG.info(String.format("\u5df2\u77e5\u5f02\u5e38,\u65b9\u6cd5:[class=%s,method=%s],\u4fe1\u606f:[resultCode=%s,resultMsg=%s]", targetClass, targetMethod, dexcoderException.getResultCode(), dexcoderException.getResultMsg()), (Throwable)dexcoderException);
        }
        catch (Throwable throwable) {
            RunBinderTransactionAspectSupport.setRollbackOnly();
            RunBinder.addError("UN_KNOWN_EXCEPTION", "\u672a\u77e5\u5f02\u5e38");
            LOG.error(String.format("\u672a\u77e5\u5f02\u5e38,\u65b9\u6cd5:[class=%s,method=%s]", targetClass, targetMethod), throwable);
        }
        long endTime = System.currentTimeMillis();
        long useTime = endTime - beginTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("end:[class={},method={},endTime={},usedTime={}]", new Object[]{targetClass, targetMethod, endTime, useTime});
        }
        if (useTime > 1000L) {
            LOG.warn("Long processing time:[class={},method={},usedTime={}]", new Object[]{targetClass, targetMethod, useTime});
        }
        return result;
    }
}

