/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.pager;

import com.dexcoder.commons.bean.BeanConverter;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pager
implements Serializable {
    private static final long serialVersionUID = 8852394572921412518L;
    public static final int DEFAULT_ITEMS_PER_PAGE = 50;
    public static final int DEFAULT_SLIDER_SIZE = 7;
    private int curPage = 1;
    private int itemsTotal = Integer.MAX_VALUE;
    private int itemsPerPage = 50;
    private List<?> list;

    public int getPages() {
        return (int)Math.ceil((double)this.itemsTotal / (double)this.itemsPerPage);
    }

    public int getCurPage() {
        return this.curPage;
    }

    public int setCurPage(int page) {
        this.curPage = this.calcPage(page);
        return this.curPage;
    }

    public int getItemsTotal() {
        return this.itemsTotal;
    }

    public List<?> getList() {
        return this.list;
    }

    public void setList(List<?> list) {
        this.list = list;
    }

    public <E> List<E> getList(Class<E> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Conversion failed,Parameter class can not be null!");
        }
        if (this.list == null || this.list.isEmpty()) {
            return null;
        }
        if (this.list.iterator().next().getClass().equals(clazz)) {
            return this.list;
        }
        return BeanConverter.convert(clazz, this.list);
    }

    public int setItemsTotal(int items) {
        this.itemsTotal = items >= 0 ? items : 0;
        this.setCurPage(this.curPage);
        return this.itemsTotal;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int setItemsPerPage(int itemsPerPage) {
        int n = this.itemsPerPage = itemsPerPage > 0 ? itemsPerPage : 50;
        if (this.curPage > 0) {
            this.setCurPage((int)((double)(this.curPage - 1) * (double)this.itemsPerPage / (double)this.itemsPerPage) + 1);
        }
        return this.itemsPerPage;
    }

    public int getOffset() {
        return this.curPage > 0 ? this.itemsPerPage * (this.curPage - 1) : 0;
    }

    public int getActualLength() {
        if (this.curPage > 0) {
            return Math.min(this.itemsPerPage * this.curPage, this.itemsTotal) - this.itemsPerPage * (this.curPage - 1);
        }
        return 0;
    }

    public int getBeginIndex() {
        if (this.curPage > 0) {
            return this.itemsPerPage * (this.curPage - 1);
        }
        return 0;
    }

    public int getEndIndex() {
        if (this.curPage > 0) {
            return Math.min(this.itemsPerPage * this.curPage, this.itemsTotal);
        }
        return 0;
    }

    public int setOffset(int offset) {
        return this.setCurPage(offset / this.itemsPerPage + 1);
    }

    public int getFirstPage() {
        return this.calcPage(1);
    }

    public int getLastPage() {
        return this.calcPage(this.getPages());
    }

    public int getPreviousPage() {
        return this.calcPage(this.curPage - 1);
    }

    public int getPreviousPage(int n) {
        return this.calcPage(this.curPage - n);
    }

    public int getNextPage() {
        return this.calcPage(this.curPage + 1);
    }

    public int getNextPage(int n) {
        return this.calcPage(this.curPage + n);
    }

    public boolean isDisabledPage(int page) {
        return page < 1 || page > this.getPages() || page == this.curPage;
    }

    public int[] getSlider() {
        return this.getSlider(7);
    }

    public int[] getSlider(int pWidth) {
        int width = pWidth;
        int pages = this.getPages();
        if (pages < 1 || width < 1) {
            return new int[0];
        }
        if (width > pages) {
            width = pages;
        }
        int[] slider = new int[width];
        int first = this.curPage - (width - 1) / 2;
        if (first < 1) {
            first = 1;
        }
        if (first + width - 1 > pages) {
            first = pages - width + 1;
        }
        for (int i = 0; i < width; ++i) {
            slider[i] = first + i;
        }
        return slider;
    }

    protected int calcPage(int page) {
        int pages = this.getPages();
        if (pages > 0) {
            return page < 1 ? 1 : (page > pages ? pages : page);
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Pager: page ");
        if (this.getPages() < 1) {
            sb.append(this.getCurPage());
        } else {
            int[] slider = this.getSlider();
            for (int i = 0; i < slider.length; ++i) {
                if (this.isDisabledPage(slider[i])) {
                    sb.append('[').append(slider[i]).append(']');
                } else {
                    sb.append(slider[i]);
                }
                if (i >= slider.length - 1) continue;
                sb.append('\t');
            }
        }
        sb.append(" of ").append(this.getPages()).append(",\n");
        sb.append("    Showing items ").append(this.getBeginIndex()).append(" to ").append(this.getEndIndex()).append(" (total ").append(this.getItemsTotal()).append(" items), ");
        sb.append("offset=").append(this.getOffset()).append(", length=").append(this.getActualLength());
        return sb.toString();
    }
}

