/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.result;

import com.dexcoder.commons.exceptions.DexcoderException;
import com.dexcoder.commons.result.RunResult;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunBinder {
    private static ThreadLocal<RunResult> resultHolder = new ThreadLocal();

    public static void addError(DexcoderException e) {
        RunBinder.addResult(false, e.getResultCode(), e.getResultMsg());
    }

    public static void addError(Throwable e) {
        RunBinder.addResult(false, "UN_KNOWN_EXCEPTION", e.getMessage());
    }

    public static void addError(String errorMsg) {
        RunBinder.addResult(false, null, errorMsg);
    }

    public static void addError(String errorCode, String errorMsg) {
        RunBinder.addResult(false, errorCode, errorMsg);
    }

    public static void addMessage(String message) {
        RunBinder.addResult(true, null, message);
    }

    public static void addMessage(String code, String message) {
        RunBinder.addResult(true, code, message);
    }

    private static void addResult(boolean success, String code, String message) {
        RunResult runResult = resultHolder.get();
        if (runResult == null) {
            runResult = new RunResult();
            resultHolder.set(runResult);
        }
        runResult.setSuccess(success);
        runResult.setCode(code);
        if (success) {
            runResult.addMessage(message);
        } else {
            runResult.addError(message);
        }
    }

    public static boolean isSuccess() {
        RunResult runResult = resultHolder.get();
        if (runResult != null) {
            return runResult.isSuccess();
        }
        return true;
    }

    public static boolean hasErrors() {
        RunResult runResult = resultHolder.get();
        return runResult != null && !runResult.isSuccess();
    }

    public static boolean hasMessages() {
        RunResult runResult = resultHolder.get();
        return runResult != null && CollectionUtils.isNotEmpty(runResult.getMessages());
    }

    public static RunResult getRunResult(boolean isClear) {
        RunResult runResult = resultHolder.get();
        if (isClear) {
            resultHolder.remove();
        }
        return runResult;
    }

    public static RunResult getRunResult() {
        return RunBinder.getRunResult(true);
    }

    public static String getStrMessages(boolean isClear) {
        RunResult runResult = resultHolder.get();
        if (runResult != null) {
            if (isClear) {
                resultHolder.remove();
            }
            return runResult.getStrMessages();
        }
        return null;
    }

    public static String getStrMessages() {
        return RunBinder.getStrMessages(true);
    }

    public static String getStrErrors(boolean isClear) {
        RunResult runResult = resultHolder.get();
        if (runResult != null) {
            if (isClear) {
                resultHolder.remove();
            }
            return runResult.getStrErrors();
        }
        return null;
    }

    public static String getStrErrors() {
        return RunBinder.getStrErrors(true);
    }

    public static List<String> getMessages(boolean isClear) {
        RunResult runResult = resultHolder.get();
        if (runResult != null) {
            if (isClear) {
                resultHolder.remove();
            }
            return runResult.getMessages();
        }
        return null;
    }

    public static List<String> getMessages() {
        return RunBinder.getMessages(true);
    }

    public static List<String> getErrors(boolean isClear) {
        RunResult runResult = resultHolder.get();
        if (runResult != null) {
            if (isClear) {
                resultHolder.remove();
            }
            return runResult.getErrors();
        }
        return null;
    }

    public static List<String> getErrors() {
        return RunBinder.getErrors(true);
    }

    public static String getCode(boolean isClear) {
        RunResult runResult = resultHolder.get();
        if (runResult != null) {
            if (isClear) {
                resultHolder.remove();
            }
            return runResult.getCode();
        }
        return null;
    }

    public static String getCode() {
        return RunBinder.getCode(true);
    }

    public static void clear() {
        resultHolder.remove();
    }
}

