/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.exceptions.CommonsAssistantException;
import com.dexcoder.commons.utils.StrUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class ImageUtils {
    private static final String DEFAULT_IMAGE_FORMAT = "jpg";

    public static void resizeAddLogoSave(InputStream srcImage, InputStream waterImage, int maxImgWidth, float alpha, int pointX, int pointY, Integer degree, String targetPath) {
        try {
            BufferedImage srcImg = ImageIO.read(srcImage);
            ImageIcon imageIcon = new ImageIcon(srcImg);
            Image image = imageIcon.getImage();
            int iWidth = image.getWidth(null);
            if (iWidth > maxImgWidth) {
                int iHeight = image.getHeight(null);
                image = iWidth > iHeight ? image.getScaledInstance(maxImgWidth, maxImgWidth * iHeight / iWidth, 4) : image.getScaledInstance(maxImgWidth * iWidth / iHeight, maxImgWidth, 4);
            }
            Image temp = new ImageIcon(image).getImage();
            BufferedImage bufferedImage = new BufferedImage(temp.getWidth(null), temp.getHeight(null), 1);
            Graphics2D g1 = bufferedImage.createGraphics();
            g1.setColor(Color.white);
            g1.fillRect(0, 0, temp.getWidth(null), temp.getHeight(null));
            g1.drawImage(temp, 0, 0, null);
            g1.dispose();
            float softenFactor = 0.05f;
            float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 4.0f, softenFactor, 0.0f, softenFactor, 0.0f};
            Kernel kernel = new Kernel(3, 3, softenArray);
            ConvolveOp cOp = new ConvolveOp(kernel, 1, null);
            bufferedImage = cOp.filter(bufferedImage, null);
            Graphics2D g = bufferedImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image.getScaledInstance(image.getWidth(null), image.getHeight(null), 4), 0, 0, null);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)bufferedImage.getWidth() / 2.0, (double)bufferedImage.getHeight() / 2.0);
            }
            ImageIcon imgIcon = new ImageIcon(ImageIO.read(waterImage));
            Image img = imgIcon.getImage();
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage(img, pointX, pointY, null);
            g.setComposite(AlphaComposite.getInstance(3));
            g.dispose();
            File fo = new File(targetPath);
            if (!fo.getParentFile().exists()) {
                fo.getParentFile().mkdirs();
            }
            String suffix = fo.getName().substring(fo.getName().lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)bufferedImage, suffix, fo);
        }
        catch (Exception e) {
            throw new CommonsAssistantException("\u7ed9\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)srcImage);
            IOUtils.closeQuietly((InputStream)waterImage);
        }
    }

    public static BufferedImage watermarkText(String logoText, Color fontColor, String fontName, int fontSize, float alpha, int pointX, int pointY, Integer degree, BufferedImage bufferedImage) {
        try {
            Graphics2D g = bufferedImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(bufferedImage.getScaledInstance(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 4), 0, 0, null);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)bufferedImage.getWidth() / 2.0, (double)bufferedImage.getHeight() / 2.0);
            }
            g.setColor(fontColor);
            g.setFont(new Font(fontName, 0, fontSize));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(logoText, pointX, pointY);
            g.dispose();
            return bufferedImage;
        }
        catch (Exception e) {
            throw new RuntimeException("\u7ed9\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u5931\u8d25", e);
        }
    }

    public static void resizeAddLogoWrite(InputStream inputStream, String logoText, int maxImgWidth, Color fontColor, String fontName, int fontSize, float alpha, int pointX, int pointY, Integer degree, String targetPath) {
    }

    public static int[] getImageWH(File imageFile) {
        byte[] bytes = ImageUtils.readFileToByte(imageFile);
        return ImageUtils.getImageWH(bytes);
    }

    public static int[] getImageWH(byte[] bytes) {
        int[] nArray;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(bytes);
            BufferedImage image = ImageIO.read(is);
            int width = image.getWidth();
            int height = image.getHeight();
            nArray = new int[]{width, height};
        }
        catch (Exception e) {
            try {
                throw new CommonsAssistantException("\u8bfb\u53d6\u56fe\u7247\u957f\u5bbd\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return nArray;
    }

    public static void resizeWriteByMaxSize(byte[] bytes, int maxSize, File targetFile) {
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, maxSize, 0, true);
        String suffix = targetFile.getName().substring(targetFile.getName().lastIndexOf(".") + 1);
        ImageUtils.writeImage(bufferedImage, suffix, targetFile);
    }

    public static void resizeWriteByMaxSize(File srcFile, int maxSize, File targetFile) {
        byte[] bytes = ImageUtils.readFileToByte(srcFile);
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, maxSize, 0, true);
        String suffix = targetFile.getName().substring(targetFile.getName().lastIndexOf(".") + 1);
        ImageUtils.writeImage(bufferedImage, suffix, targetFile);
    }

    public static void resizeWriteImageByWidth(byte[] bytes, int newWith, File targetFile) {
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, newWith, 0, false);
        String suffix = targetFile.getName().substring(targetFile.getName().lastIndexOf(".") + 1);
        ImageUtils.writeImage(bufferedImage, suffix, targetFile);
    }

    public static void resizeWriteImageByWidth(File srcFile, int newWith, File targetFile) {
        byte[] bytes = ImageUtils.readFileToByte(srcFile);
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, newWith, 0, false);
        String suffix = targetFile.getName().substring(targetFile.getName().lastIndexOf(".") + 1);
        ImageUtils.writeImage(bufferedImage, suffix, targetFile);
    }

    public static void resizeWriteImage(byte[] bytes, int newWidth, int newHeight, File targetFile) {
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, newWidth, newHeight, false);
        String suffix = targetFile.getName().substring(targetFile.getName().lastIndexOf(".") + 1);
        ImageUtils.writeImage(bufferedImage, suffix, targetFile);
    }

    public static void resizeWriteImage(File srcFile, int newWidth, int newHeight, File targetFile) {
        byte[] bytes = ImageUtils.readFileToByte(srcFile);
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, newWidth, newHeight, false);
        String suffix = targetFile.getName().substring(targetFile.getName().lastIndexOf(".") + 1);
        ImageUtils.writeImage(bufferedImage, suffix, targetFile);
    }

    public static byte[] resizeByMaxSize(byte[] bytes, int maxSize) {
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, maxSize, 0, true);
        return ImageUtils.bufferedImageToByte(bufferedImage, DEFAULT_IMAGE_FORMAT);
    }

    public static byte[] resizeByMaxSize(File srcFile, int maxSize) {
        byte[] bytes = ImageUtils.readFileToByte(srcFile);
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, maxSize, 0, true);
        String suffix = srcFile.getName().substring(srcFile.getName().lastIndexOf(".") + 1);
        return ImageUtils.bufferedImageToByte(bufferedImage, suffix);
    }

    public static byte[] resizeImageByWidth(byte[] bytes, int newWith) {
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, newWith, 0, false);
        return ImageUtils.bufferedImageToByte(bufferedImage, DEFAULT_IMAGE_FORMAT);
    }

    public static byte[] resizeImageByWidth(File srcFile, int newWith) {
        byte[] bytes = ImageUtils.readFileToByte(srcFile);
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, newWith, 0, false);
        String suffix = srcFile.getName().substring(srcFile.getName().lastIndexOf(".") + 1);
        return ImageUtils.bufferedImageToByte(bufferedImage, suffix);
    }

    public static byte[] resizeImage(byte[] bytes, int newWidth, int newHeight) {
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, newWidth, newHeight, false);
        return ImageUtils.bufferedImageToByte(bufferedImage, DEFAULT_IMAGE_FORMAT);
    }

    public static byte[] resizeImage(File srcFile, int newWidth, int newHeight) {
        byte[] bytes = ImageUtils.readFileToByte(srcFile);
        BufferedImage bufferedImage = ImageUtils.resizeImage(bytes, newWidth, newHeight, false);
        String suffix = srcFile.getName().substring(srcFile.getName().lastIndexOf(".") + 1);
        return ImageUtils.bufferedImageToByte(bufferedImage, suffix);
    }

    public static byte[] resizeCutImage(byte[] bytes, int cutWidth, int cutHeight) {
        BufferedImage bufferedImage = ImageUtils.resizeCutImage(bytes, cutWidth, cutHeight, true);
        return ImageUtils.bufferedImageToByte(bufferedImage, DEFAULT_IMAGE_FORMAT);
    }

    public static byte[] resizeCutImage(File srcFile, int cutWidth, int cutHeight) {
        byte[] bytes = ImageUtils.readFileToByte(srcFile);
        BufferedImage bufferedImage = ImageUtils.resizeCutImage(bytes, cutWidth, cutHeight, true);
        String suffix = srcFile.getName().substring(srcFile.getName().lastIndexOf(".") + 1);
        return ImageUtils.bufferedImageToByte(bufferedImage, suffix);
    }

    public static void resizeCutWriteImage(File srcFile, int newWidth, int newHeight, File targetFile) {
        byte[] bytes = ImageUtils.readFileToByte(srcFile);
        BufferedImage bufferedImage = ImageUtils.resizeCutImage(bytes, newWidth, newHeight, true);
        String suffix = targetFile.getName().substring(targetFile.getName().lastIndexOf(".") + 1);
        ImageUtils.writeImage(bufferedImage, suffix, targetFile);
    }

    public static void resizeCutWriteImage(byte[] bytes, int newWidth, int newHeight, File targetFile) {
        BufferedImage bufferedImage = ImageUtils.resizeCutImage(bytes, newWidth, newHeight, true);
        String suffix = targetFile.getName().substring(targetFile.getName().lastIndexOf(".") + 1);
        ImageUtils.writeImage(bufferedImage, suffix, targetFile);
    }

    public static byte[] cutImage(File imageFile, int x, int y, int cutWidth, int cutHeight) {
        try {
            BufferedImage image = ImageIO.read(imageFile);
            image = image.getSubimage(x, y, cutWidth, cutHeight);
            String suffix = imageFile.getName().substring(imageFile.getName().lastIndexOf(".") + 1);
            return ImageUtils.bufferedImageToByte(image, suffix);
        }
        catch (IOException e) {
            throw new CommonsAssistantException("\u8bfb\u53d6\u56fe\u7247\u5931\u8d25", (Throwable)e);
        }
    }

    public static byte[] cutImage(byte[] imageBytes, int x, int y, int cutWidth, int cutHeight) {
        BufferedImage image = ImageUtils.readByteToBufferedImage(imageBytes);
        image = image.getSubimage(x, y, cutWidth, cutHeight);
        return ImageUtils.bufferedImageToByte(image, DEFAULT_IMAGE_FORMAT);
    }

    private static byte[] bufferedImageToByte(BufferedImage bufferedImage, String imageFormat) {
        ByteArrayOutputStream bos = null;
        try {
            byte[] data;
            bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, StrUtils.isBlank(imageFormat) ? DEFAULT_IMAGE_FORMAT : imageFormat, bos);
            byte[] byArray = data = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new CommonsAssistantException("\u5c06BufferedImage\u8f6c\u6362\u6210byte\u6570\u7ec4\u5931\u8d25", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bos);
        }
    }

    private static byte[] readFileToByte(File srcFile) {
        try {
            byte[] bytes = FileUtils.readFileToByteArray((File)srcFile);
            return bytes;
        }
        catch (IOException e) {
            throw new CommonsAssistantException("\u5c06\u56fe\u7247\u6587\u4ef6\u8f6c\u6362\u6210byte\u6570\u7ec4\u5931\u8d25", (Throwable)e);
        }
    }

    private static BufferedImage readByteToBufferedImage(byte[] bytes) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(bytes));
            return image;
        }
        catch (IOException e) {
            throw new CommonsAssistantException("\u5c06byte\u6570\u7ec4\u8f6c\u6362\u6210BufferedImage\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
        }
    }

    private static void writeImage(BufferedImage bufferedImage, String formatName, File targetFile) {
        try {
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            ImageIO.write((RenderedImage)bufferedImage, formatName, targetFile);
        }
        catch (IOException e) {
            throw new CommonsAssistantException("\u56fe\u7247\u5199\u5165\u5931\u8d25", (Throwable)e);
        }
    }

    private static BufferedImage resizeImage(byte[] bytes, int newWidth, int newHeight, boolean isDoHeight) {
        int iHeight;
        int iWidth;
        BufferedImage srcImage = null;
        try {
            srcImage = ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u56fe\u7247\u6210BufferedImage\u5931\u8d25", e);
        }
        Image resizedImage = null;
        resizedImage = newHeight > 0 ? srcImage.getScaledInstance(newWidth, newHeight, 4) : ((iWidth = srcImage.getWidth(null)) < (iHeight = srcImage.getHeight(null)) && isDoHeight ? srcImage.getScaledInstance(newWidth * iWidth / iHeight, newWidth, 4) : srcImage.getScaledInstance(newWidth, newWidth * iHeight / iWidth, 4));
        Image temp = new ImageIcon(resizedImage).getImage();
        BufferedImage bufferedImage = new BufferedImage(temp.getWidth(null), temp.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, temp.getWidth(null), temp.getHeight(null));
        g.drawImage(temp, 0, 0, null);
        g.dispose();
        float softenFactor = 0.05f;
        float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 4.0f, softenFactor, 0.0f, softenFactor, 0.0f};
        Kernel kernel = new Kernel(3, 3, softenArray);
        ConvolveOp cOp = new ConvolveOp(kernel, 1, null);
        bufferedImage = cOp.filter(bufferedImage, null);
        return bufferedImage;
    }

    private static BufferedImage resizeCutImage(byte[] bytes, int cutWidth, int cutHeight, boolean isZoom) {
        BufferedImage image = ImageUtils.readByteToBufferedImage(bytes);
        if (isZoom) {
            int imageHeight;
            int imageWidth = image.getWidth();
            double scale = imageWidth < (imageHeight = image.getHeight()) ? (double)imageWidth / (double)cutWidth : (double)imageHeight / (double)cutHeight;
            int newImageWidth = (int)((double)imageWidth / scale);
            int newImageHeight = (int)((double)imageHeight / scale);
            image = ImageUtils.resizeImage(bytes, Math.max(newImageWidth, cutWidth), Math.max(newImageHeight, cutHeight), false);
        }
        Image temp = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(cutWidth, cutHeight, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, cutWidth, cutHeight);
        g.drawImage(temp, 0, 0, null);
        g.dispose();
        float softenFactor = 0.05f;
        float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 4.0f, softenFactor, 0.0f, softenFactor, 0.0f};
        Kernel kernel = new Kernel(3, 3, softenArray);
        ConvolveOp cOp = new ConvolveOp(kernel, 1, null);
        bufferedImage = cOp.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static String getImageFormat(File image) {
        byte[] bytes = ImageUtils.readFileToByte(image);
        return ImageUtils.getImageFormat(bytes);
    }

    public static String getImageFormat(byte[] image) {
        ImageInputStream iis = null;
        try {
            iis = ImageIO.createImageInputStream(new ByteArrayInputStream(image));
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            ImageReader reader = iter.next();
            String string = reader.getFormatName();
            return string;
        }
        catch (IOException e) {
            throw new CommonsAssistantException("\u83b7\u53d6\u56fe\u7247\u683c\u5f0f\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                iis.close();
            }
            catch (IOException e) {}
        }
    }
}

