/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.commons.utils.UUIDUtils;

public class NameUtils {
    public static String getFirstUpperName(String name) {
        if (StrUtils.isBlank(name)) {
            return null;
        }
        String firstChar = StrUtils.substring(name, 0, 1).toUpperCase();
        return firstChar + StrUtils.substring(name, 1);
    }

    public static String getFirstLowerName(String name) {
        if (StrUtils.isBlank(name)) {
            return null;
        }
        String firstChar = StrUtils.substring(name, 0, 1).toLowerCase();
        return firstChar + StrUtils.substring(name, 1);
    }

    public static void main(String[] args) {
        System.out.println(NameUtils.getCamelName("login-name-info", '-'));
        System.out.println(NameUtils.getCamelName("LOGIN-NAME-INFO", '-'));
        System.out.println(NameUtils.getCamelName("-login-name-info-", '-'));
        System.out.println(NameUtils.getCamelName("-LOGIN-NAME-INFO-", '-'));
    }

    public static String getCamelName(String name) {
        return NameUtils.getCamelName(name, '_');
    }

    public static String getCamelName(String name, char delimiter) {
        if (StrUtils.isBlank(name)) {
            return null;
        }
        name = StrUtils.lowerCase(name);
        while (name.charAt(0) == delimiter) {
            name = StrUtils.substring(name, 1);
        }
        while (name.charAt(name.length() - 1) == delimiter) {
            name = StrUtils.substring(name, 0, name.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == delimiter) {
                sb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getUnderlineName(String name) {
        return NameUtils.getUpperDelimiterName(name, "_");
    }

    public static String getLineThroughName(String name) {
        return NameUtils.getLowerDelimiterName(name, "-");
    }

    public static String getUpperDelimiterName(String name, String delimiter) {
        return NameUtils.getLowerDelimiterName(name, delimiter).toUpperCase();
    }

    public static String getLowerDelimiterName(String name, String delimiter) {
        if (StrUtils.isBlank(name)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                sb.append(delimiter);
            }
            sb.append(c);
        }
        return sb.toString().toLowerCase();
    }

    public static String createUniqueFileName(String fileName) {
        int index = StrUtils.lastIndexOf(fileName, ".");
        String suffix = StrUtils.substring(fileName, index);
        String uqName = UUIDUtils.getUUID16() + suffix;
        return uqName;
    }

    public static String createEndSuffixFileName(String fileName, String endSuffix) {
        int index = StrUtils.lastIndexOf(fileName, ".");
        String preFileName = StrUtils.substring(fileName, 0, index);
        String suffix = StrUtils.substring(fileName, index);
        return preFileName + endSuffix + suffix;
    }
}

